package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.cache.BuyerResponseCache;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.micrometer.ExchangeCallableMeter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;

import java.util.Objects;
import java.util.concurrent.Callable;

/**
 * @author zhangdong
 * @date 2022/12/7
 */
public class ExchangeCacheCallable implements Callable<Deal> {

    private final BidRequest bidRequest;
    private final Dispatcher dispatcher;
    private final BuyerWrapper buyerWrapper;
    private final BuyerResponseCache buyerResponseCache;
    private final ExchangeCallableMeter exchangeCallableMeter;
    public ExchangeCacheCallable(BidRequest bidRequest, BuyerWrapper buyerWrapper, BuyerResponseCache buyerResponseCache,
                                 ExchangeCallableMeter exchangeCallableMeter) {
        this.bidRequest = bidRequest;
        this.buyerWrapper = buyerWrapper;
        this.dispatcher = buyerWrapper.getDispatcher();
        this.buyerResponseCache = buyerResponseCache;
        this.exchangeCallableMeter = exchangeCallableMeter;
    }


    @Override
    public Deal call() {
        long start = System.nanoTime();
        try {
            BidResponse response = buyerResponseCache.getResponse(bidRequest, buyerWrapper);
            if (Objects.nonNull(response)) {
                return new Deal(Deal.CACHE_DEAL, buyerWrapper.getBuyer(), bidRequest, response, dispatcher);
            }
            return null;
        } finally {
            exchangeCallableMeter.recordCacheExchange(start);
        }
    }
}
