package com.bxm.adx.common.market.exchange.rebuild.request;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.position.AdvertPoint;
import com.bxm.adx.common.buy.position.AdvertPointService;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.App;
import com.bxm.mccms.facade.model.pushable.SysDictCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.pair.Pair;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

import java.util.Objects;
import java.util.Set;

/**
 * 重构BidRequest中的App
 *
 * @author fgf
 * @date 2023/1/6
 **/
@Configuration
public class AppBuilder implements AdxBidRequestBuilder {
    private final AdvertPointService advertPointService;
    private final Pair pair;
    private final static String KEY = "adx.app.package.dsp.list";
    private static final String DSP_TANX = "tanx";
    private final Fetcher fetcher;

    public AppBuilder(AdvertPointService advertPointService, Pair pair, Fetcher fetcher) {
        this.advertPointService = advertPointService;
        this.pair = pair;
        this.fetcher = fetcher;
    }

    @Override
    public void rebuildAdxBidRequest(BidRequest adxBidRequest, RequestBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getBuyerWrapper().getDispatcher();
        AdvertPoint advertPoint = advertPointService.getAdvertPointByDspId(dispatcher.getDspId().toString(), dispatcher.getDspAppid(), dispatcher.getDspPosid());
        App app = new App();
        if (Objects.nonNull(adxBidRequest.getApp())) {
            BeanUtils.copyProperties(adxBidRequest.getApp(), app);
        }

        boolean pass = isPassThrough(dispatcher);
        //应用id使用端点的数据，埋点关联
        app.setId(dispatcher.getDspAppid());
        Buyer buyer = attribute.getBuyerWrapper().getBuyer();
        rebuildAppInfo(app, pass, dispatcher, advertPoint, buyer);

        adxBidRequest.setApp(app);
    }

    /**
     * 重建媒体信息
     *
     * @param app
     * @param pass
     * @param dispatcher
     * @param advertPoint
     * @param buyer
     */
    private void rebuildAppInfo(App app, boolean pass, Dispatcher dispatcher, AdvertPoint advertPoint, Buyer buyer) {
        if (DSP_TANX.equals(buyer.getCode())){
            if (StringUtils.isNotBlank(app.getBundle())) {
                // 获取 app 包名映射
                KeyGenerator appNameKey = CacheKeys.getAppNameSysDictKeyGenerator(app.getBundle());
                SysDictCacheVO sysDictCacheVO = fetcher.fetch(appNameKey, SysDictCacheVO.class);
                if (Objects.nonNull(sysDictCacheVO)){
                    app.setName(sysDictCacheVO.getDictValue());
                }
                KeyGenerator appCategoryKey = CacheKeys.getAppCatSysDictKeyGenerator(app.getBundle());
                SysDictCacheVO categorySysDict = fetcher.fetch(appCategoryKey, SysDictCacheVO.class);
                if (Objects.nonNull(categorySysDict)){
                    app.setCat(categorySysDict.getDictValue());
                }
                if (StringUtils.isBlank(app.getCat())){
                    app.setCat("1050");
                }
            }
        }
        if (pass) {
            //透传，如果媒体信息为空，填充端点数据
            if (StringUtils.isEmpty(app.getBundle())) {
                if (StringUtils.isNotBlank(dispatcher.getAppPackageName())) {
                    app.setBundle(dispatcher.getAppPackageName());
                }
            }
            if (StringUtils.isEmpty(app.getName())) {
                if (Objects.nonNull(advertPoint) && StringUtils.isNotBlank(advertPoint.getAppName())) {
                    app.setName(advertPoint.getAppName());
                }
            }
            if (StringUtils.isEmpty(app.getVer())) {
                if (Objects.nonNull(advertPoint) && StringUtils.isNotBlank(advertPoint.getVersion())) {
                    app.setVer(advertPoint.getVersion());
                }
            }
        } else {
            if (DSP_TANX.equals(buyer.getCode()) && StringUtils.isNotBlank(app.getName())) {
                return;
            }
            //非透传默认覆盖媒体app信息
            if (Objects.nonNull(advertPoint)) {
                app.setVer(advertPoint.getVersion());
                app.setName(advertPoint.getAppName());
            }
            app.setId(dispatcher.getDspAppid());
            app.setBundle(dispatcher.getAppPackageName());
        }
    }

    /**
     * 是否透传媒体信息
     * @return
     */
    private boolean isPassThrough(Dispatcher dispatcher) {
        Set<String> dspIds = pair.get(KEY).ofHashSet();
        if (CollectionUtils.isNotEmpty(dspIds)) {
            String dspId = String.valueOf(dispatcher.getDspId());
            if (dspIds.contains(dspId)) {
                return true;
            }
        }
        return false;
    }
}
