package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferFactory;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferResult;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * 媒体出价
 *
 * @author fgf
 * @date 2023/1/10
 **/
@Slf4j
@Configuration
public class OfferPriceBuilder implements AdxBidResponseBuilder {
    private final OfferFactory factory;

    public OfferPriceBuilder(OfferFactory factory) {
        this.factory = factory;
    }

    @Override
    public int getOrder() {
        return 5;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            Map<Bid, OfferResult> offerResultMap = factory.offer(seatBid.getBid(), attribute);
            for (Bid bid : seatBid.getBid()) {
                OfferResult result = offerResultMap.get(bid);
                int chargeType = result.getChargeType();
                bid.setCharge_type(chargeType);
                int budgetType = result.getBudgetType();
                bid.setBudget_type(budgetType);

                switch (budgetType) {
                    case AdxConstants
                            .ChargeType.CPM:
                        bid.setPrice(result.getOffer());
                        bid.setBid(null);
                        break;
                    case AdxConstants
                            .ChargeType.CPC:
                        bid.setBid(result.getOffer());
                        bid.setPrice(null);
                        break;
                    case AdxConstants.ChargeType.OCPM:
                        bid.setObid(result.getOffer());
                        bid.setPrice(null);
                        bid.setBid(null);
                        break;
                    default:
                        log.warn("unsupported budgetType, dispatcher {}", attribute.getDispatcher().getId());
                        throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
                }
            }
        }
    }
}
