package com.bxm.adx.common.market.monitor;


import com.bxm.adx.common.report.ServerReportService;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.warcar.integration.pair.Pair;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.Objects;
import java.util.Set;

/**
 * @author weixing
 */
@Slf4j
public class WinNoticeHandler implements MonitorHandler{
    private final ServerReportService serverReportService;
    private final static String WIN_NOTICE_DSP_LIST_KEY = "adx.win.notice.dsp";
    private final Pair pair;


    public WinNoticeHandler(ServerReportService serverReportService, Pair pair) {
        this.serverReportService = serverReportService;
        this.pair = pair;
    }

    @Override
    public void handler(BuildAttribute attribute) {
        Bid bid = attribute.getBid();
        if(Objects.isNull(bid) || StringUtils.isBlank(bid.getNurl())){
            return;
        }
        // 指定dsp上报竞胜url
        Set<String> dspIdList = pair.get(WIN_NOTICE_DSP_LIST_KEY).ofHashSet();
        String nurl = bid.getNurl();
        if (!CollectionUtils.isEmpty(dspIdList) &&  dspIdList.contains(String.valueOf(attribute.getDspId()))) {
            serverReportService.reportWinNoticeUrl(nurl);
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
