package com.bxm.adx.common.openlog.event.internal;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.sell.BidRequest;

import java.util.EventObject;
import java.util.Map;
import java.util.Set;

/**
 * @author fgf
 * @date 2023/3/26
 **/
public class AdxFilterEvent extends EventObject {
    private final BidRequest sspRequest;
    private final Map<Integer, Set<Deal>> trashMap;
    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @param sspRequest
     * @param trashMap
     * @throws IllegalArgumentException if source is null.
     */
    public AdxFilterEvent(Object source, BidRequest sspRequest, Map<Integer, Set<Deal>> trashMap) {
        super(source);
        this.sspRequest = sspRequest;
        this.trashMap = trashMap;
    }

    public Map<Integer, Set<Deal>> getTrashMap() {
        return trashMap;
    }

    public BidRequest getSspRequest() {
        return sspRequest;
    }
}
