package com.bxm.adx.common.openlog.event.internal;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.sell.BidRequest;

import java.util.EventObject;

/**
 * adx向dsp发起请求事件
 * @author fgf
 * @date 2022/6/1
 **/
public class AdxRequestEvent extends EventObject {
    private final BidRequest sspRequest;
    private final BidRequest adxRequest;
    private final Long dspId;
    private final Dispatcher dispatcher;
    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @param sspRequest
     * @param adxRequest
     * @param dspId
     * @param dispatcher
     * @throws IllegalArgumentException if source is null.
     */
    public AdxRequestEvent(Object source, BidRequest sspRequest, BidRequest adxRequest, Long dspId, Dispatcher dispatcher) {
        super(source);
        this.sspRequest = sspRequest;
        this.adxRequest = adxRequest;
        this.dspId = dspId;

        this.dispatcher = dispatcher;
    }

    public Long getDspId() {
        return dspId;
    }

    public BidRequest getSspRequest() {
        return sspRequest;
    }

    public BidRequest getAdxRequest() {
        return adxRequest;
    }

    public Dispatcher getDispatcher() {
        return dispatcher;
    }
}
