package com.bxm.adx.common.openlog.event.internal;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang.StringUtils;

import java.io.IOException;
import java.util.EventObject;

/**
 * dsp竞价返回事件
 * @author fgf
 * @date 2022/6/2
 */
public class DspBidEvent extends EventObject {
    private final BidRequest sspRequest;
    private final BidRequest adxRequest;
    private String dspResponse;
    private final Long dspId;
    private final Long strategyId;
    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @param sspRequest
     * @param adxRequest
     * @param dspResponse
     * @param dspId
     * @param strategyId
     * @throws IllegalArgumentException if source is null.
     */
    public DspBidEvent(Object source, BidRequest sspRequest, BidRequest adxRequest, BidResponse dspResponse,
                       Long dspId, Long strategyId) {
        super(source);
        this.sspRequest = sspRequest;
        this.adxRequest = adxRequest;
        this.dspId = dspId;
        this.strategyId = strategyId;
        this.dspResponse = serialize(dspResponse);
    }

    //以后全转protobuf，在序列化上方便
    private String serialize(BidResponse dspResponse) {
        try {
            String json = new ObjectMapper().writeValueAsString(dspResponse);
            return json;
        } catch (JsonProcessingException e) {
            return StringUtils.EMPTY;
        }
    }

    public BidRequest getSspRequest() {
        return sspRequest;
    }

    public BidRequest getAdxRequest() {
        return adxRequest;
    }

    public BidResponse getDspResponse() {
        if (StringUtils.isNotEmpty(dspResponse)) {
            try {
                return new ObjectMapper().readValue(dspResponse, BidResponse.class);
            } catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public Long getDspId() {
        return dspId;
    }

    public Long getStrategyId() {
        return strategyId;
    }
}
