package com.bxm.adx.common.openlog.listener.external;

import com.bxm.adx.common.openlog.event.external.AdShowEvent;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Adx;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

/**
 * @author allen
 * @date 2022-04-25
 * @since 1.0
 */
@Slf4j
@Configuration
public class AdShowForDspMaxExposureLimiterEventListener implements EventListener<AdShowEvent> {

    private final Counter counter;

    public AdShowForDspMaxExposureLimiterEventListener(Counter counter) {
        this.counter = counter;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdShowEvent event) {
        handleDspExposureWithConfigId(event);
    }

    private void handleDspExposureWithConfigId(AdShowEvent event) {
        KeyValueMap map = event.getLog();
        String dspId = map.getFirst(Adx.Param.DSPID);
        String configId = map.getFirst(Adx.Param.CONFIGID);
        String dspTagId = map.getFirst(Adx.Param.DTAGID);

        //统计dsp流量分配维度曝光
        KeyGenerator keyGenerator = AdxKeyGenerator.Counter.getPositionDspExposure(configId, dspId, dspTagId);
        LocalDateTime midnight = LocalDateTime.now().plusDays(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
        long seconds = ChronoUnit.SECONDS.between(LocalDateTime.now(),midnight);
        counter.incrementAndGet(keyGenerator, (int)seconds);

        try {
            //统计dsp流量分配出价维度曝光
            String dpcId = map.getFirst("dpcid");
            KeyGenerator k = AdxKeyGenerator.Counter.getPositionDspExposure(configId, dspId, dspTagId,dpcId);
            counter.incrementAndGet(k, (int)seconds);
        } catch (Exception e) {
            log.error("Statistical bidding dimension exposure anomaly：",e);
        }
    }
}
