package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.limiter.InsertExpireHandler;
import com.bxm.adx.common.openlog.event.internal.DspBidEvent;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.Data;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

/**
 * @author fgf
 * @date 2024/7/22
 **/
@Configuration
public class DotDspBidForDeviceEventListener implements EventListener<DspBidEvent> {

    private final InsertExpireHandler insertExpireHandler;
    private final Properties properties = new Properties();

    public DotDspBidForDeviceEventListener(@Qualifier("insertExpireDeviceCrowdPackageHandler") InsertExpireHandler insertExpireHandler) {
        this.insertExpireHandler = insertExpireHandler;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(DspBidEvent event) {
        Long dspId = event.getDspId();
        if (dspId.equals(properties.dspId)) {
            String crowdId = properties.getCrowdId();
//            LocalDate now = LocalDate.now();
//            if (now.isBefore(properties.getStart()) || now.isAfter(properties.getEnd())) {
//                return;
//            }
            KeyGenerator key = CacheKeys.getCrowdPackageNewKey(event.getSspRequest().getDevice());
            if (Objects.nonNull(key)) {
                long crowdExpire = getExpire();
                long keyExpire = crowdExpire - System.currentTimeMillis() / 1000;
                insertExpireHandler.insert(key, crowdId, crowdExpire + "", (int) keyExpire);
            }
        }
    }

    private long getExpire() {
        // 获取当前时间
        LocalDateTime now = LocalDateTime.now();
        // 计算一周后的时间
        LocalDateTime oneWeekLater = now.plus(1, ChronoUnit.WEEKS);
        // 获取当前时区
        ZoneId currentZone = ZoneId.systemDefault();
        // 将一周后的时间转换为时间戳（毫秒级别）
        long timestamp = oneWeekLater.atZone(currentZone).toInstant().toEpochMilli() / 1000;
        return timestamp;
    }

    @Data
    static class Properties {
        private Long dspId = 103L;
        private String crowdId = "184";
        private LocalDate start = LocalDate.of(2024, 7, 22);
        private LocalDate end = LocalDate.of(2024, 7, 29);
    }
}
