package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.cipher.PriceCipher;
import com.bxm.adx.common.openlog.event.internal.DspWinEvent;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.consts.Adx;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author fgf
 * @date 2024/5/8
 **/
@Slf4j
@Configuration
public class DotDspWinEventListener implements EventListener<DspWinEvent> {
    private OpenLogClient openLogClient;
    private final AdxProperties properties;

    public DotDspWinEventListener(AdxProperties properties) {
        this.properties = properties;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(DspWinEvent event) {
        BigDecimal win = event.getWin();
        if (Objects.nonNull(win)) {
            MultiValueMap<String, String> originalParams = event.getOriginalParams();
            boolean success = event.getSuccess();
            MultiValueMap<String, String> customizeParams = new LinkedMultiValueMap<>();
            try {
                String dspWinPrice = PriceCipher.encryptWin(win.toString(), properties.getCipherProperties().getDspPriceKey());
                originalParams.set(OpenlogConstants.MacrosCustomizeParams.DSP_WIN_PRICE, dspWinPrice);
            } catch (Exception e) {
                log.error("win {} bidid {} err", win, originalParams.getFirst(Adx.Param.BIDID), e);
            }
            customizeParams.add(OpenlogConstants.MacrosCustomizeParams.SERVER_REPORT_RESULT,  success ? "1" : "0");
            customizeParams.add(OpenlogConstants.MacrosCustomizeParams.SERVER_REPORT_TIME, System.currentTimeMillis() + "");

            String url = properties.getOpenLog().create(OpenlogConstants.Mt.DSP_WIN_SECOND_AUCTION_MT, originalParams, customizeParams);
            if (log.isDebugEnabled()) {
                log.debug("report second auction mt url {}", url);
            }
            openLogClient.asyncRequest(url);
        }
    }
}
