package com.bxm.adx.common.report;

import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.cipher.PriceCipher;
import com.bxm.adx.common.entity.DspPriceDotParam;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.warcar.utils.JsonHelper;
import lombok.Builder;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;

/**
 * @author fgf
 * @date 2024/4/27
 **/
@Builder
@Data
@Slf4j
public class ReportParam {
    private String bidId;
    private String adId;
    /**
     * 媒体成交类型
     */
    private String chargeType;
    private Integer bidModel;
    private ReportType type;
    private String dspId;
    private String mediaId;
    private String appId;
    private String mediaWinPrice;
    private String advWinPriceModel;
    private String dspPriceConfig;

    public Integer getChargeType() {
        if (Objects.isNull(chargeType)) {
            return null;
        } else {
            return Integer.valueOf(chargeType);
        }
    }

    public BigDecimal getDspWinPrice(String key) {
        if (StringUtils.isBlank(mediaWinPrice)) {
            return null;
        }
        if (StringUtils.isBlank(advWinPriceModel)) {
            return null;
        }
        Integer model = Integer.valueOf(advWinPriceModel);
        if (DispatcherPriceConfig.ADV_WIN_PRICE_TYPE_MEDIA == model) {
            DspPriceDotParam priceDotParam = null;
            try {
                priceDotParam = JsonHelper.convert(PriceCipher.decryptWin(dspPriceConfig, key), DspPriceDotParam.class);
            } catch (Exception e) {
                log.error("err", e);
                throw new AdxException(AdxErrEnum.UNKNOWN_ERR);
            }
            BigDecimal win = new BigDecimal(mediaWinPrice);
            BigDecimal basePrice = null;
            switch (type) {
                case IMP:
                    //曝光赢价已经是单次曝光的价格，并且单位是厘，转成千次曝光价格单位分：win * 1000 / 10
                    win = win.movePointRight(3);
                    win = win.movePointLeft(1);
                    basePrice = priceDotParam.getDprpre();
                    break;
                case CLICK:
                    win = win.movePointLeft(1);
                    basePrice = priceDotParam.getDpr();
                    break;
                default:
                    log.error("unknown type {}", type.name());
                    return null;
            }
            BigDecimal mediaBaseWin = win.divide(
                    new BigDecimal(100)
                            .subtract(priceDotParam.getPm())
                            .movePointLeft(2)
                            .setScale(2, RoundingMode.HALF_UP), 0, RoundingMode.HALF_UP);
            if (mediaBaseWin.compareTo(basePrice) == 1) {
                return basePrice;
            } else {
                return mediaBaseWin;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "ReportParam{" +
                "bidId='" + bidId + '\'' +
                ", adId='" + adId + '\'' +
                ", chargeType='" + chargeType + '\'' +
                ", bidModel=" + bidModel +
                ", type=" + type +
                ", dspId='" + dspId + '\'' +
                ", mediaId='" + mediaId + '\'' +
                ", appId='" + appId + '\'' +
                '}';
    }
}
