package com.bxm.adx.common.sysdict;

import com.bxm.mccms.facade.model.pushable.SysDictCacheVO;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;
import java.util.Objects;

/**
 * @author weixing
 */
@Slf4j
@CachePush("SYS_DICT")
public class SysDictDaoImpl implements SysDictDao, Pushable {
    private final DataSyncProducer dataSyncProducer;
    private final Updater updater;

    public SysDictDaoImpl(DataSyncProducer dataSyncProducer, Updater updater) {
        this.dataSyncProducer = dataSyncProducer;
        this.updater = updater;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isInfoEnabled()) {
            log.info("sysdict data = {}", JsonHelper.convert(data, String.class));
        }

        SysDictCacheVO sysDictCacheVO = JsonHelper.convert(data, SysDictCacheVO.class);
        if (Objects.isNull(sysDictCacheVO) || Objects.isNull(sysDictCacheVO.getId())) {
            return;
        }
        // 只处理已安装包名和tanx app分类
        if (!"package_name".equals(sysDictCacheVO.getParentDictValue()) || !"tanx_category".equals(sysDictCacheVO.getParentDictValue())) {
            return;
        }
        String key = sysDictCacheVO.getClass().getName() + "$" + sysDictCacheVO.getId();
        dataSyncProducer.post(key, sysDictCacheVO);
        updater.update(getKeyGenerator(sysDictCacheVO.getParentDictValue(), sysDictCacheVO.getDictName()), sysDictCacheVO);
    }

    private KeyGenerator getKeyGenerator(String parentDictValue, String dictName) {
        return () -> KeyBuilder.build("ADX", "SYS_DICT", parentDictValue, dictName);
    }
}
