/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common;

import com.bxm.adx.common.sell.request.Device;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class CacheKeys {
    public static KeyGenerator getBidRequestKeyGenerator(String bidid) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "POSITION", "SCENE", "BIDREQUEST", bidid});
    }

    public static KeyGenerator getActivityErrGenerator(String positionId, String type) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "SCENE", "ACTIVITY", positionId, type});
    }

    public static KeyGenerator getDspRequestCount(String dspId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DSP", "COUNT", "REQ", dspId});
    }

    public static KeyGenerator getDspResponseCount(String dspId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DSP", "COUNT", "RESP", dspId});
    }

    public static KeyGenerator getDspNowQPS(String time) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DSP", "QPS", time});
    }

    public static KeyGenerator getDspQPSBan(String time) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DSP", "QPS", "BAN", time});
    }

    public static KeyGenerator getPackageNameKey() {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "PACKAGENAME", "VERIFY"});
    }

    public static KeyGenerator getClickMacroDsp() {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DSP", "MACRO", "CLICK"});
    }

    public static KeyGenerator getVideoMacroDsp() {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DSP", "MACRO", "VIDEO"});
    }

    public static KeyGenerator getResponseCacheKey(String dspId, String dspTagId, String uid) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "CACHE", "RESPONSE", dspId, dspTagId, uid});
    }

    public static KeyGenerator getCrowdPackageNewKey(Device device) {
        if (Objects.nonNull(device)) {
            if (StringUtils.isNotBlank((String)device.getOaid_md5())) {
                return () -> KeyBuilder.build((Object[])new Object[]{"oaid", device.getOaid_md5()});
            }
            if (StringUtils.isNotBlank((String)device.getImei_md5())) {
                return () -> KeyBuilder.build((Object[])new Object[]{"imei", device.getImei_md5()});
            }
            if (StringUtils.isNotBlank((String)device.getIdfa_md5())) {
                return () -> KeyBuilder.build((Object[])new Object[]{"idfa", device.getIdfa_md5()});
            }
            if (StringUtils.isNotBlank((String)device.getCaid())) {
                return () -> KeyBuilder.build((Object[])new Object[]{"caid", device.getCaid()});
            }
        }
        return null;
    }

    public static KeyGenerator getImpUrl302(String bidId, String mediaId, String tagId, String dspId, String dspTagId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "IMP", bidId, mediaId, tagId, dspId, dspTagId});
    }

    public static KeyGenerator getAppNameSysDictKeyGenerator(String dictName) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "SYS_DICT", "package_name", dictName});
    }

    public static KeyGenerator getAppCatSysDictKeyGenerator(String dictName) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "SYS_DICT", "tanx_category", dictName});
    }

    public static class DispatcherFlow {
        public static String baseFlow(String param) {
            return KeyBuilder.build((Object[])new Object[]{"ADX", "FLOW", param});
        }

        public static String basePercent(String param) {
            return KeyBuilder.build((Object[])new Object[]{"ADX", "CUT", param});
        }

        public static KeyGenerator getDispatcherFlow(String date, String dspId, String dspTagId, String dspAppId, String tagId, String appId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "FLOW", date, dspId, dspTagId, dspAppId, tagId, appId});
        }

        public static KeyGenerator getDispatcherFlowPercent(String date, String dspId, String dspAppId, String dspTagId, String tagId, String appPkg) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "CUT", date, dspId, dspAppId, dspTagId, tagId, appPkg});
        }
    }

    public static class ServerReport {
        public static KeyGenerator getServerReportTempKey(String type, String bidid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"SERVER", "REPORT", type, bidid});
        }

        public static KeyGenerator getServerReportTempKey(String type, String bidid, String adId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"SERVER", "REPORT", type, bidid, adId});
        }
    }

    public static class Dispather {
        public static KeyGenerator getKeyGenerator(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DISPATHER", "PID_AB", positionId});
        }

        public static KeyGenerator getKeyGeneratorByAppPosId(String appPosId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DISPATHER", "APPID_AB", appPosId});
        }

        public static KeyGenerator getKeyGeneratorByBucketing(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DISPATHER", "BUCKETING_AB", positionId});
        }

        public static KeyGenerator getKeyGeneratorByAll(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DISPATHER", "ALL_AB", positionId});
        }

        public static KeyGenerator getDispatcherKeyGeneratorByUid(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DISPATHER", "USER_AB", positionId});
        }

        public static KeyGenerator getKeyGeneratorByConfig(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DISPATHER", "PID_AB", "CONFIG", positionId});
        }

        public static KeyGenerator getKeyGeneratorByConfigAndAppPosId(String appPosId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DISPATHER", "APPID_AB", "CONFIG", appPosId});
        }
    }
}

