/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.autoconfigure;

import com.bxm.adx.common.utils.ServerUtils;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GlobalServerConfig {
    private static final Logger log = LoggerFactory.getLogger(GlobalServerConfig.class);
    public static final List<String> IP_LIST = Lists.newArrayList((Object[])new String[]{"172.21.3.54", "172.21.3.55", "172.21.3.64"});
    private String localIpAddress;

    @PostConstruct
    public void init() {
        this.localIpAddress = ServerUtils.getLocalIpAddress();
        log.info("Server IP Address: " + this.localIpAddress);
    }

    public String getLocalIpAddress() {
        return this.localIpAddress;
    }

    public boolean hit() {
        return IP_LIST.contains(this.getLocalIpAddress());
    }
}

