/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.autoconfigure;

import com.bxm.adx.common.autoconfigure.GlobalServerConfig;
import com.bxm.adx.common.utils.ServerUtils;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OnMultipleConditions
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean condition1 = this.checkSpecificIp();
        boolean condition2 = this.checkEnvironmentVariable(context);
        return condition1 || condition2;
    }

    private boolean checkSpecificIp() {
        String localIp = ServerUtils.getLocalIpAddress();
        return GlobalServerConfig.IP_LIST.contains(localIp);
    }

    private boolean checkEnvironmentVariable(ConditionContext context) {
        Environment env = context.getEnvironment();
        String myProperty = env.getProperty("adx.enable-model-adapter-proxy-factory");
        return "true".equalsIgnoreCase(myProperty);
    }
}

