/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.autoconfigure;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.ServerReportProperties;
import com.bxm.adx.common.market.monitor.ServerReportHandler;
import com.bxm.adx.common.market.monitor.WinNoticeHandler;
import com.bxm.adx.common.openlog.listener.external.AdClickForServerReportEventListener;
import com.bxm.adx.common.openlog.listener.external.AdShowForServerReportEventListener;
import com.bxm.adx.common.report.DefaultHttpClientReportClient;
import com.bxm.adx.common.report.DspWinPriceHandler;
import com.bxm.adx.common.report.ReportClient;
import com.bxm.adx.common.report.ServerReportService;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.JedisPool;

@ConditionalOnProperty(prefix="adx.server-report", value={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={ServerReportProperties.class})
public class ServerReportAutoConfiguration {
    private final ServerReportProperties serverReportProperties;

    public ServerReportAutoConfiguration(ServerReportProperties serverReportProperties) {
        this.serverReportProperties = serverReportProperties;
    }

    @Bean
    public ReportClient reportClient() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 10, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("report-client"));
        return DefaultHttpClientReportClient.builder().setExecutor(executor).build();
    }

    @Bean
    public ServerReportService serverReportService(JedisPool jedisPool, ReportClient reportClient, AdxProperties properties, EventPark eventPark, DspWinPriceHandler dspWinPriceHandler) {
        return new ServerReportService(this.serverReportProperties, jedisPool, reportClient, properties, eventPark, dspWinPriceHandler);
    }

    @Bean
    public ServerReportHandler serverReportHandler(ServerReportService serverReportService) {
        return new ServerReportHandler(serverReportService);
    }

    @Bean
    public WinNoticeHandler winNoticeHandler(ServerReportService serverReportService, Pair pair) {
        return new WinNoticeHandler(serverReportService, pair);
    }

    @Bean
    public AdShowForServerReportEventListener adShowForServerReportEventListener(ServerReportService serverReportService) {
        return new AdShowForServerReportEventListener(serverReportService);
    }

    @Bean
    public AdClickForServerReportEventListener adClickForServerReportEventListener(ServerReportService serverReportService) {
        return new AdClickForServerReportEventListener(serverReportService);
    }
}

