/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.buy.dispatcher.DispatcherService;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfig;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfigCaching;
import com.bxm.adx.common.buy.dispatcher.abtest.cached.DispatcherCached;
import com.bxm.adx.common.buy.dispatcher.abtest.cached.DispatcherConfigCached;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilterFactory;
import com.bxm.adx.common.buy.dispatcher.reorder.DispatcherReorderFactory;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.utils.AdxUtils;
import com.bxm.adx.common.utils.DateUtils;
import com.bxm.adx.common.utils.MapHelper;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class DispatcherServiceImpl
implements DispatcherService {
    private static final Logger log = LoggerFactory.getLogger(DispatcherServiceImpl.class);
    private static final Integer DELAY = 15;
    private final DispatcherConfigCached dispatcherConfigCached;
    private final DispatcherABConfigCaching dispatcherABConfigCaching;
    private final DispatcherCached dispatcherCached;
    private final DispatcherFilterFactory dispatcherFilterFactory;
    private final DispatcherReorderFactory dispatcherReorderFactory;

    public DispatcherServiceImpl(DispatcherConfigCached dispatcherConfigCached, DispatcherABConfigCaching dispatcherABConfigCaching, DispatcherCached dispatcherCached, DispatcherFilterFactory dispatcherFilterFactory, DispatcherReorderFactory dispatcherReorderFactory) {
        this.dispatcherConfigCached = dispatcherConfigCached;
        this.dispatcherABConfigCaching = dispatcherABConfigCaching;
        this.dispatcherCached = dispatcherCached;
        this.dispatcherFilterFactory = dispatcherFilterFactory;
        this.dispatcherReorderFactory = dispatcherReorderFactory;
    }

    @Override
    public Map<Integer, Collection<Dispatcher>> getPriority(Position position, BidRequest bidRequest) {
        TreeMap dsps = Maps.newTreeMap();
        Collection<Dispatcher> dispatchers = this.getDispatchers(position);
        dispatchers = dispatchers.stream().filter(dispatcherDspCacheVO -> dispatcherDspCacheVO.getOpened() == 1).collect(Collectors.toSet());
        DispatcherContext<Dispatcher> context = DispatcherContext.builder().values(dispatchers).position(position).request(bidRequest).build();
        this.dispatcherFilterFactory.filter(context);
        dispatchers = this.dispatcherReorderFactory.reorder(context);
        for (Dispatcher dispatcher : dispatchers) {
            int priority = dispatcher.getPriority();
            Collection collection = MapHelper.get(dsps, Integer.valueOf(priority), new ArrayList());
            dispatcher.setDispatcherPriceConfigs(this.getDispatcherPriceConfig(dispatcher));
            collection.add(dispatcher);
        }
        return dsps;
    }

    private Collection<Dispatcher> getDispatchers(Position position) {
        int userBucket;
        Long configId;
        String positionId = position.getPositionId();
        DispatcherABConfig dispatcherABConfig = (DispatcherABConfig)this.dispatcherABConfigCaching.get(positionId);
        if (Objects.isNull(dispatcherABConfig)) {
            return Sets.newHashSet();
        }
        String uid = AdxContextFactory.get().getUid();
        if (StringUtils.isEmpty((Object)uid)) {
            uid = RandomStringUtils.randomAlphabetic((int)13);
        }
        if (Objects.isNull(configId = this.dispatcherConfigCached.getConfigId(positionId, userBucket = AdxUtils.getBucket(uid)))) {
            if (log.isWarnEnabled()) {
                log.warn("position {} user bucket {} fail ", (Object)positionId, (Object)userBucket);
            }
            return Sets.newHashSet();
        }
        AdxContextFactory.get().setConfigId(configId);
        return this.dispatcherCached.getDispatchers(positionId, configId);
    }

    private List<DispatcherPriceConfig> getDispatcherPriceConfig(Dispatcher dispatcher) {
        List<DispatcherPriceConfig> priceConfigs = this.getPriceConfigsByTime(dispatcher);
        if (Objects.isNull(priceConfigs)) {
            return null;
        }
        if (CollectionUtils.isEmpty(priceConfigs)) {
            log.warn("position {} dispatcher {} price config empty err", (Object)dispatcher.getPositionId(), (Object)dispatcher.getId());
            if (2 == dispatcher.getAvgType()) {
                log.error("position {} dispatcher {} avg-type {} err", new Object[]{dispatcher.getPositionId(), dispatcher.getId(), dispatcher.getAvgType()});
                throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
            }
            priceConfigs.add(DispatcherPriceConfig.builder().ltPriceDiscountFactor(BigDecimal.ONE).gtPriceDiscountFactor(BigDecimal.ONE).biddingCoefficient(BigDecimal.ONE).profitMargin(BigDecimal.ZERO).build());
        }
        return priceConfigs;
    }

    private List<DispatcherPriceConfig> getPriceConfigsByTime(Dispatcher dispatcher) {
        List<DispatcherPriceConfig> configs = dispatcher.getDispatcherDspPosPriceConfigVOS();
        if (CollectionUtils.isEmpty(configs)) {
            return null;
        }
        ArrayList<DispatcherPriceConfig> priceConfigs = new ArrayList<DispatcherPriceConfig>();
        int hour = LocalDateTime.now().get(ChronoField.HOUR_OF_DAY);
        for (DispatcherPriceConfig config : configs) {
            Integer opened = config.getOpened();
            if (opened != null && opened == 1) continue;
            Integer start = config.getStartTime();
            Integer end = config.getEndTime();
            if (!Objects.nonNull(start) || !Objects.nonNull(end) || start > hour || hour >= end) continue;
            this.bidOptimizerConfig(config, dispatcher);
            priceConfigs.add(config);
        }
        return priceConfigs;
    }

    private void bidOptimizerConfig(DispatcherPriceConfig config, Dispatcher dispatcher) {
        Date date;
        long duration;
        if (Objects.nonNull(dispatcher.getCpcControl()) && dispatcher.getCpcControl() == 1 && (duration = DateUtils.getDuration(date = dispatcher.getProjectTime())) <= (long)DELAY.intValue()) {
            BigDecimal coefficient = dispatcher.getProjectBiddingCoefficient();
            BigDecimal discount = dispatcher.getProjectDiscount();
            if (Objects.nonNull(coefficient) && Objects.nonNull(discount)) {
                config.setBiddingCoefficient(coefficient);
                config.setGtPriceDiscountFactor(discount);
                config.setLtPriceDiscountFactor(discount);
            }
        }
    }
}

