/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.filter;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilterCondition;
import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.rule.AndOrSetRule;
import com.bxm.adx.common.rule.Rule;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.warcar.integration.pair.Pair;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@DispatcherFilterCondition(probeOn=false)
@Configuration
public class DeviceFilter
implements DispatcherFilter<Dispatcher> {
    private static final Logger log = LoggerFactory.getLogger(DeviceFilter.class);
    private final Pair pair;
    private static final Set<String> DEVICE_ID_NAMES = Sets.newHashSet((Object[])new String[]{"imei", "idfa", "oaid", "gaid"});
    private static final String EXCEPTION_DEVICE_LIST = "adx.exception.device.list";

    public DeviceFilter(Pair pair) {
        this.pair = pair;
    }

    @Override
    public void filter(DispatcherContext<Dispatcher> context, Set<Id> trash) {
        Device device = context.getRequest().getDevice();
        this.filterDevice(context.getRequest(), device);
        Set removes = context.getValues().stream().filter(dispatcher -> this.limitByDevice((Dispatcher)dispatcher, device)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(removes)) {
            trash.addAll(removes);
        }
    }

    private void filterDevice(BidRequest request, Device device) {
        String oaid;
        String idfa;
        if (request.getExpId() == 0) {
            return;
        }
        Set blackSet = Optional.of(this.pair.get(EXCEPTION_DEVICE_LIST).ofHashSet()).orElse(new HashSet());
        String imei = device.getImei();
        String imeiMd5 = device.getImei_md5();
        String oaidMd5 = device.getOaid_md5();
        String idfaMd5 = device.getIdfa_md5();
        if (StringUtils.isNotBlank((String)imei) && (!imei.matches("\\d+") || imei.length() != 14 && imei.length() != 15 || blackSet.contains(imei))) {
            device.setImei(null);
            if (DigestUtils.md5Hex((String)imei).equals(imeiMd5)) {
                device.setImei_md5(null);
            }
        }
        if (StringUtils.isNotBlank((String)(idfa = device.getIdfa())) && blackSet.contains(idfa)) {
            device.setIdfa(null);
            if (DigestUtils.md5Hex((String)idfa).equals(idfaMd5)) {
                device.setIdfa_md5(null);
            }
        }
        if (StringUtils.isNotBlank((String)(oaid = device.getOaid())) && blackSet.contains(oaid)) {
            device.setOaid(null);
            if (DigestUtils.md5Hex((String)oaid).equals(oaidMd5)) {
                device.setOaid_md5(null);
            }
        }
        if (this.isErrorDevice(imeiMd5, blackSet)) {
            device.setImei_md5(null);
        }
        if (this.isErrorDevice(idfaMd5, blackSet)) {
            device.setIdfa_md5(null);
        }
        if (this.isErrorDevice(oaidMd5, blackSet)) {
            device.setOaid_md5(null);
        }
    }

    private boolean isErrorDevice(String md5, Set<String> blackSet) {
        return StringUtils.isNotBlank((String)md5) && md5.length() != 32 || blackSet.contains(md5);
    }

    public int getOrder() {
        return 1;
    }

    private boolean limitByDevice(Dispatcher dispatcher, Device device) {
        Rule deviceRule = dispatcher.getDeviceInfo();
        if (Objects.isNull(deviceRule)) {
            return false;
        }
        String ruleVal = deviceRule.getRuleValue();
        if (StringUtils.isNotEmpty((String)ruleVal)) {
            deviceRule.setRuleValue(ruleVal.replace(",", "/"));
        }
        AndOrSetRule andOrSetRule = new AndOrSetRule(deviceRule);
        Set<String> paramNames = andOrSetRule.getAndParamNameSet();
        for (String paramName : paramNames) {
            if (andOrSetRule.isOrParams(paramName)) {
                Set<String> orParams = andOrSetRule.getOrParamNameSet(paramName);
                if (CollectionUtils.isEmpty(orParams)) continue;
                boolean orLimit = false;
                for (String orParamName : orParams) {
                    if (!this.hasFieldVal(device, orParamName)) continue;
                    orLimit = true;
                    break;
                }
                if (orLimit) continue;
                return true;
            }
            if (this.hasFieldVal(device, paramName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasFieldVal(Device device, String fieldName) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add(fieldName);
        if (DEVICE_ID_NAMES.contains(fieldName)) {
            fieldNames.add(fieldName + "_md5");
        }
        try {
            Class<?> cla = device.getClass();
            for (String name : fieldNames) {
                boolean hasVal;
                Field field = cla.getDeclaredField(name);
                field.setAccessible(true);
                Object val = field.get(device);
                if (log.isDebugEnabled()) {
                    log.debug("check device param {} val {}", (Object)name, Optional.ofNullable(val).orElse(null));
                }
                if (!(hasVal = Objects.nonNull(val) && StringUtils.isNotBlank((String)val.toString()))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

