/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.filter;

import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfig;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfigChangeHandler;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherConfig;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilterCondition;
import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.ip.IpService;
import com.bxm.adx.common.rule.Rule;
import com.bxm.adx.common.rule.WhiteBlackSetRule;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.utils.MapHelper;
import com.bxm.warcar.ip.IP;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@DispatcherFilterCondition(probeOn=false)
@Configuration
public class RegionFilter
implements DispatcherFilter<Dispatcher>,
DispatcherABConfigChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(RegionFilter.class);
    private final ConcurrentHashMap<String, Set<String>> dispatcherRegionMap = new ConcurrentHashMap();
    private final CopyOnWriteArraySet<String> whiteDispatcherIdSet = Sets.newCopyOnWriteArraySet();
    private final IpService ipService;

    public RegionFilter(IpService ipService) {
        this.ipService = ipService;
    }

    @Override
    public void filter(DispatcherContext<Dispatcher> context, Set<Id> trash) {
        Set regionDispatcher = context.getValues().stream().filter(dispatcher -> Objects.nonNull(dispatcher.getCitys())).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(regionDispatcher)) {
            return;
        }
        IP ip = this.initIp(context.getRequest());
        Set removes = regionDispatcher.stream().filter(dispatcher -> this.limitByRegion((Dispatcher)dispatcher, ip)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(removes)) {
            trash.addAll(removes);
        }
    }

    public int getOrder() {
        return 0;
    }

    private boolean limitByRegion(Dispatcher dispatcher, IP ip) {
        String id = dispatcher.getId();
        Set<String> values = this.dispatcherRegionMap.get(id);
        boolean isWhite = this.whiteDispatcherIdSet.contains(id);
        if (CollectionUtils.isEmpty(values)) {
            log.warn("Position {} Dispatcher {} region empty", (Object)dispatcher.getPositionId(), (Object)dispatcher.getId());
            return isWhite;
        }
        if (ip.isHit()) {
            boolean b;
            String hitcode = ip.getHitcode();
            String province = this.getCodeForProvince(hitcode);
            String city = this.getCodeForCity(hitcode);
            boolean bl = b = values.contains(hitcode) || values.contains(province) || values.contains(city);
            if (b && !isWhite) {
                return true;
            }
            return !b && isWhite;
        }
        return isWhite;
    }

    private String getCodeForProvince(String code) {
        return org.apache.commons.lang.StringUtils.rightPad((String)org.apache.commons.lang.StringUtils.left((String)code, (int)2), (int)6, (String)"0");
    }

    private String getCodeForCity(String code) {
        return org.apache.commons.lang.StringUtils.rightPad((String)org.apache.commons.lang.StringUtils.left((String)code, (int)4), (int)6, (String)"0");
    }

    private IP initIp(BidRequest bidRequest) {
        String ipStr;
        IP ip = AdxContextFactory.get().getIp();
        if (Objects.nonNull(ip)) {
            return ip;
        }
        Device device = bidRequest.getDevice();
        if (device != null && !StringUtils.isEmpty((Object)(ipStr = device.getIp()))) {
            ip = this.ipService.analyze(ipStr);
            AdxContextFactory.get().setIp(ip);
        }
        return ip;
    }

    @Override
    public void doUpdate(DispatcherABConfig old, DispatcherABConfig latest) {
        if (this.isExecuteUpdateAndDoDelete(old, latest)) {
            List<DispatcherConfig> dispatcherConfigs = latest.getDispatcherConfigCaches();
            if (CollectionUtils.isEmpty(dispatcherConfigs)) {
                return;
            }
            for (DispatcherConfig dispatcherConfig : dispatcherConfigs) {
                List<Dispatcher> dispatchers = dispatcherConfig.getDispatcherDspCaches();
                if (CollectionUtils.isEmpty(dispatchers)) continue;
                for (Dispatcher dispatcher : dispatchers) {
                    if (dispatcher.getOpened() == 0) continue;
                    Rule rule = dispatcher.getCitys();
                    String id = dispatcher.getId();
                    if (Objects.isNull(rule)) continue;
                    WhiteBlackSetRule whiteBlackSetRule = new WhiteBlackSetRule(rule);
                    Set<String> values = whiteBlackSetRule.getSet();
                    if (whiteBlackSetRule.isWhite()) {
                        this.whiteDispatcherIdSet.add(id);
                    }
                    ((Set)MapHelper.get(this.dispatcherRegionMap, id, new CopyOnWriteArraySet())).addAll(values);
                }
            }
        }
    }

    @Override
    public void doDelete(DispatcherABConfig old) {
        List<DispatcherConfig> dispatcherConfigs = old.getDispatcherConfigCaches();
        if (CollectionUtils.isEmpty(dispatcherConfigs)) {
            return;
        }
        for (DispatcherConfig dispatcherConfig : dispatcherConfigs) {
            List<Dispatcher> dispatchers = dispatcherConfig.getDispatcherDspCaches();
            if (CollectionUtils.isEmpty(dispatchers)) continue;
            for (Dispatcher dispatcher : dispatchers) {
                Rule rule = dispatcher.getCitys();
                if (Objects.isNull(rule)) continue;
                WhiteBlackSetRule whiteBlackSetRule = new WhiteBlackSetRule(rule);
                Set<String> values = whiteBlackSetRule.getSet();
                String id = dispatcher.getId();
                if (whiteBlackSetRule.isWhite()) {
                    this.whiteDispatcherIdSet.remove(id);
                }
                this.dispatcherRegionMap.remove(id);
            }
        }
    }
}

