/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dsp;

import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspCached;
import com.bxm.adx.common.buy.dsp.DspDao;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@CachePush(value="DSP")
@Component
public class DspDaoImpl
implements DspDao,
Pushable {
    private static final Logger log = LoggerFactory.getLogger(DspDaoImpl.class);
    private final Updater updater;
    private final DataSyncProducer dataSyncProducer;
    private final DspCached dspCached;

    public DspDaoImpl(Updater updater, DataSyncProducer dataSyncProducer, DspCached dspCached) {
        this.updater = updater;
        this.dataSyncProducer = dataSyncProducer;
        this.dspCached = dspCached;
    }

    @Override
    public Collection<Dsp> getAll() {
        Collection<Dsp> dsps = this.dspCached.getAll();
        return dsps;
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isInfoEnabled()) {
            log.info("dsp = {}", (Object)new String(data));
        }
        Dsp dsp = (Dsp)JsonHelper.convert((byte[])data, Dsp.class);
        Long id = dsp.getId();
        String key = dsp.getClass().getName() + "$" + id;
        this.dataSyncProducer.post(key, (Object)dsp);
        this.updater.hremove(this.getKeyGenerator(), new String[]{Objects.toString(id)});
        if (!dsp.isForbidden()) {
            this.updater.hupdate(this.getKeyGenerator(), Objects.toString(id), (Object)dsp);
        }
    }

    private KeyGenerator getKeyGenerator() {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DSPS"});
    }
}

