/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.creative.review;

import com.bxm.adx.common.creative.review.ReviewCreative;
import com.bxm.adx.common.creative.review.ReviewCreativeCaching;
import com.bxm.adx.common.creative.review.ReviewCreativeDao;
import com.bxm.mccms.facade.model.pushable.CreativeReviewCacheVO;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CachePush(value="CREATIVE_REVIEW")
public class ReviewCreativeDaoImpl
implements ReviewCreativeDao,
Pushable {
    private static final Logger log = LoggerFactory.getLogger(ReviewCreativeDaoImpl.class);
    private final DataSyncProducer dataSyncProducer;
    private final ReviewCreativeCaching reviewCreativeCaching;

    public ReviewCreativeDaoImpl(DataSyncProducer dataSyncProducer, ReviewCreativeCaching reviewCreativeCaching) {
        this.dataSyncProducer = dataSyncProducer;
        this.reviewCreativeCaching = reviewCreativeCaching;
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        CreativeReviewCacheVO creativeReviewCacheVO;
        if (log.isInfoEnabled()) {
            log.info("review creative data = {}", JsonHelper.convert((byte[])data, String.class));
        }
        if (Objects.isNull(creativeReviewCacheVO = (CreativeReviewCacheVO)JsonHelper.convert((byte[])data, CreativeReviewCacheVO.class)) || Objects.isNull(creativeReviewCacheVO.getId())) {
            return;
        }
        log.info("reviewCreativePush data : {}", (Object)JsonHelper.convert((Object)creativeReviewCacheVO));
        String key = creativeReviewCacheVO.getClass().getName() + "$" + creativeReviewCacheVO.getId();
        this.dataSyncProducer.post(key, (Object)creativeReviewCacheVO);
    }

    @Override
    public List<ReviewCreative> queryCreativeListByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        ArrayList creatives = Lists.newArrayListWithCapacity((int)ids.size());
        for (Long id : ids) {
            if (Objects.isNull(id)) continue;
            ReviewCreative reviewCreative = null;
            reviewCreative = (ReviewCreative)this.reviewCreativeCaching.get(String.valueOf(id));
            if (Objects.isNull(reviewCreative)) {
                if (!log.isWarnEnabled()) continue;
                log.warn("review-creative id = {}, not exist", (Object)id);
                continue;
            }
            creatives.add(reviewCreative);
        }
        return creatives;
    }
}

