/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.log;

import com.bxm.adx.common.autoconfigure.GlobalServerConfig;
import com.bxm.adx.common.log.AdxDataLog;
import com.bxm.adx.common.log.ByteLogger;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.LocalDateTime;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component
public class DailyLogService
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DailyLogService.class);
    private static final Integer LIMIT = 100;
    private static Cache<String, String> counterCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private final BlockingQueue<AdxDataLog> queue = new LinkedBlockingQueue<AdxDataLog>(1000);
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("daily-log"));
    private final Counter counter;
    private final ByteLogger byteLogger;
    private final GlobalServerConfig globalServerConfig;

    public DailyLogService(Counter counter, ByteLogger byteLogger, GlobalServerConfig globalServerConfig) {
        this.counter = counter;
        this.byteLogger = byteLogger;
        this.globalServerConfig = globalServerConfig;
        this.startHandleQueue();
    }

    public void log(AdxDataLog dataLog) {
        if (!this.globalServerConfig.hit()) {
            return;
        }
        if (!this.queue.offer(dataLog) && log.isDebugEnabled()) {
            log.debug("the queue was full.");
        }
    }

    private boolean limit(AdxDataLog dataLog) {
        String positionId = dataLog.getPositionId();
        if (StringUtils.isEmpty((String)positionId)) {
            return true;
        }
        int hour = this.getDateHour();
        String cacheKey = this.buildLocalCacheKey(positionId, hour);
        if (null != counterCache.getIfPresent((Object)cacheKey)) {
            return true;
        }
        Long count = this.counter.incrementAndGet(this.buildKey(positionId, hour), 4000);
        if (count > (long)LIMIT.intValue()) {
            counterCache.put((Object)cacheKey, (Object)"");
            return true;
        }
        return false;
    }

    private void startHandleQueue() {
        this.executor.execute(() -> {
            while (true) {
                try {
                    while (true) {
                        AdxDataLog dataLog;
                        if (this.limit(dataLog = this.queue.take())) {
                            continue;
                        }
                        this.byteLogger.add(dataLog);
                    }
                }
                catch (Exception e) {
                    log.warn("log err", (Throwable)e);
                    continue;
                }
                break;
            }
        });
    }

    private int getDateHour() {
        return LocalDateTime.now().getHour();
    }

    private KeyGenerator buildKey(String positionId, int hour) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "LOG", "REQ", hour, positionId});
    }

    private String buildLocalCacheKey(String positionId, int hour) {
        return positionId + "-" + hour;
    }

    public void destroy() throws Exception {
        this.executor.shutdownNow();
    }
}

