/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.log.buriedSwitch;

import com.bxm.adx.common.log.buriedSwitch.BuriedSwitch;
import com.bxm.adx.common.log.buriedSwitch.BuriedSwitchChangeHandler;
import com.bxm.warcar.utils.MapHelper;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BuriedSwitchCached
implements BuriedSwitchChangeHandler {
    private final ConcurrentHashMap<String, CopyOnWriteArraySet<String>> positionMap = new ConcurrentHashMap();

    @Override
    public void doUpdate(BuriedSwitch old, BuriedSwitch latest) {
        if (this.isExecuteUpdateAndDoDelete(old, latest) && latest.getOpened() == 1) {
            String positionId = latest.getPositionId();
            String dspInfo = latest.getDspId() + "-" + latest.getDspPosid();
            ((CopyOnWriteArraySet)MapHelper.get(this.positionMap, (Object)positionId, new CopyOnWriteArraySet())).add(dspInfo);
        }
    }

    @Override
    public void doDelete(BuriedSwitch old) {
        String positionId = old.getPositionId();
        String dspInfo = old.getDspId() + "-" + old.getDspPosid();
        ((CopyOnWriteArraySet)MapHelper.get(this.positionMap, (Object)positionId, new CopyOnWriteArraySet())).remove(dspInfo);
        if (CollectionUtils.isEmpty((Collection)this.positionMap.get(positionId))) {
            this.positionMap.remove(positionId);
        }
    }

    public boolean contains(String positionId) {
        return this.positionMap.containsKey(positionId);
    }
}

