/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.cache.BuyerResponseCache;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.micrometer.ExchangeCallableMeter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import java.util.Objects;
import java.util.concurrent.Callable;

public class ExchangeCacheCallable
implements Callable<Deal> {
    private final BidRequest bidRequest;
    private final Dispatcher dispatcher;
    private final BuyerWrapper buyerWrapper;
    private final BuyerResponseCache buyerResponseCache;
    private final ExchangeCallableMeter exchangeCallableMeter;

    public ExchangeCacheCallable(BidRequest bidRequest, BuyerWrapper buyerWrapper, BuyerResponseCache buyerResponseCache, ExchangeCallableMeter exchangeCallableMeter) {
        this.bidRequest = bidRequest;
        this.buyerWrapper = buyerWrapper;
        this.dispatcher = buyerWrapper.getDispatcher();
        this.buyerResponseCache = buyerResponseCache;
        this.exchangeCallableMeter = exchangeCallableMeter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Deal call() {
        long start = System.nanoTime();
        try {
            BidResponse response = this.buyerResponseCache.getResponse(this.bidRequest, this.buyerWrapper);
            if (Objects.nonNull(response)) {
                Deal deal = new Deal(1, this.buyerWrapper.getBuyer(), this.bidRequest, response, this.dispatcher);
                return deal;
            }
            Deal deal = null;
            return deal;
        }
        finally {
            this.exchangeCallableMeter.recordCacheExchange(start);
        }
    }
}

