/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.warcar.ip.IP;
import com.google.common.collect.Maps;
import java.util.Map;

public class ExchangeContext {
    private static final ThreadLocal<ExchangeContext> THREAD_LOCAL = new ThreadLocal<ExchangeContext>(){

        @Override
        protected ExchangeContext initialValue() {
            return new ExchangeContext();
        }
    };
    private static final String KEY_BIDREQUEST = "$$BID_REQUEST$$";
    private static final String KEY_ADXREQUEST = "$$ADX_REQUEST$$";
    private static final String KEY_BUYER = "$$BUYER$$";
    @Deprecated
    private static final String KEY_DISPATCH_CONFIG = "$$DISPATCH_CONFIG$$";
    private static final String KEY_DISPATCH = "$$DISPATCH$$";
    private static final String KEY_PLUGINLOG = "$$PLUGINLOG$$";
    private static final String KEY_IP = "$$IP$$";
    private static final String KEY_BIDRESPONSE = "$$BID_RESPONSE$$";
    private final Map<Object, Object> attachment = Maps.newHashMap();

    private static ExchangeContext get() {
        return THREAD_LOCAL.get();
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }

    static void putBidRequest(BidRequest bidRequest) {
        ExchangeContext.get().attachment.put(KEY_BIDREQUEST, bidRequest);
    }

    static void putAdxRequest(BidRequest adxRequest) {
        ExchangeContext.get().attachment.put(KEY_ADXREQUEST, adxRequest);
    }

    static void putBuyer(Buyer buyer) {
        ExchangeContext.get().attachment.put(KEY_BUYER, buyer);
    }

    @Deprecated
    static void putDispatchConfig(Long configId) {
        ExchangeContext.get().attachment.put(KEY_DISPATCH_CONFIG, configId);
    }

    static void putDispatch(Dispatcher dispatcher) {
        ExchangeContext.get().attachment.put(KEY_DISPATCH, dispatcher);
    }

    static void putDataLog(boolean log) {
        ExchangeContext.get().attachment.put(KEY_PLUGINLOG, log);
    }

    static void putIp(IP ip) {
        ExchangeContext.get().attachment.put(KEY_IP, ip);
    }

    public static void put(Object key, Object value) {
        ExchangeContext context = ExchangeContext.get();
        context.attachment.put(key, value);
    }

    public static Object get(Object key) {
        ExchangeContext context = ExchangeContext.get();
        return context.attachment.get(key);
    }

    public static BidRequest getBidRequest() {
        Object o = ExchangeContext.get().attachment.get(KEY_BIDREQUEST);
        if (o instanceof BidRequest) {
            return (BidRequest)o;
        }
        return null;
    }

    public static BidRequest getAdxRequest() {
        Object o = ExchangeContext.get().attachment.get(KEY_ADXREQUEST);
        if (o instanceof BidRequest) {
            return (BidRequest)o;
        }
        return null;
    }

    public static Buyer getBuyer() {
        Object o = ExchangeContext.get().attachment.get(KEY_BUYER);
        if (o instanceof Buyer) {
            return (Buyer)o;
        }
        return null;
    }

    @Deprecated
    public static Long getDispatcherConfigId() {
        Object o = ExchangeContext.get().attachment.get(KEY_DISPATCH_CONFIG);
        if (o instanceof Long) {
            return (Long)o;
        }
        return null;
    }

    public static Dispatcher getDispatcher() {
        Object o = ExchangeContext.get().attachment.get(KEY_DISPATCH);
        if (o instanceof Dispatcher) {
            return (Dispatcher)o;
        }
        return null;
    }

    public static boolean getPluginLog() {
        Object o = ExchangeContext.get().attachment.get(KEY_PLUGINLOG);
        if (!(o instanceof Boolean)) {
            return false;
        }
        return (Boolean)o;
    }

    public static IP getIp() {
        Object o = ExchangeContext.get().attachment.get(KEY_IP);
        if (o instanceof IP) {
            return (IP)o;
        }
        return null;
    }

    public static void putBidResponse(BidResponse bidResponse) {
        ExchangeContext.get().attachment.put(KEY_BIDRESPONSE, bidResponse);
    }

    public static BidResponse getBidResponse() {
        Object o = ExchangeContext.get().attachment.get(KEY_BIDRESPONSE);
        if (o instanceof BidResponse) {
            return (BidResponse)o;
        }
        return null;
    }
}

