/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.filter;

import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.filter.DispatcherPriceConfigFilter;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BidModelDispatcherPriceConfigFilter
implements DispatcherPriceConfigFilter {
    private static final Logger log = LoggerFactory.getLogger(BidModelDispatcherPriceConfigFilter.class);

    @Override
    public void filter(Collection<DispatcherPriceConfig> priceConfigs, Bid bid, SeatBid seatBid, ResponseBuildAttribute attribute) {
        int bidModel = attribute.getBidRequest().getBid_model();
        priceConfigs.removeIf(priceConfig -> !this.checkMediaCostTypeByBidModel(bidModel, (DispatcherPriceConfig)priceConfig));
    }

    private boolean checkMediaCostTypeByBidModel(int bidModel, DispatcherPriceConfig config) {
        Integer mediaCostType = config.getMediaCostType();
        switch (bidModel) {
            case 1: {
                return 1 == mediaCostType;
            }
            case 2: {
                return 2 == mediaCostType;
            }
            case 3: {
                return 2 == mediaCostType || 1 == mediaCostType;
            }
            case 4: {
                return 2 == mediaCostType || 1 == mediaCostType || 3 == mediaCostType;
            }
        }
        log.warn("unsupport bidmodel");
        return false;
    }

    public int getOrder() {
        return 0;
    }
}

