/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.filter;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.filter.DispatcherPriceConfigFilter;
import com.bxm.adx.common.market.exchange.rebuild.filter.DispatcherPriceConfigFilterEnum;
import com.bxm.adx.common.market.exchange.rebuild.filter.FilterInfo;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.openlog.event.internal.AdxDispatcherPriceConfigFilter;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;

@Configuration
public class DispatcherPriceConfigFilterFactory
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(DispatcherPriceConfigFilterFactory.class);
    private final Collection<DispatcherPriceConfigFilter> filters = Lists.newArrayList();
    private final EventPark eventPark;

    public DispatcherPriceConfigFilterFactory(EventPark eventPark) {
        this.eventPark = eventPark;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext context = event.getApplicationContext();
        Map filterMap = context.getBeansOfType(DispatcherPriceConfigFilter.class);
        if (CollectionUtils.isEmpty((Map)filterMap)) {
            return;
        }
        this.filters.addAll(filterMap.values().stream().sorted(Comparator.comparing(Ordered::getOrder)).collect(Collectors.toList()));
        if (log.isInfoEnabled()) {
            this.filters.forEach(filter -> log.info("Registered DispatcherPriceConfigFilter: {} - {}", (Object)filter.getOrder(), filter));
        }
    }

    public void filter(BidResponse response, ResponseBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getDispatcher();
        List<DispatcherPriceConfig> priceConfigs = dispatcher.getDispatcherPriceConfigs();
        ArrayList<FilterInfo> filterInfos = new ArrayList<FilterInfo>();
        for (SeatBid seatBid : response.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                ArrayList collection = Lists.newArrayList(priceConfigs);
                HashMap filterConfigMap = Maps.newHashMap();
                this.filters.forEach(filter -> {
                    ArrayList temp = Lists.newArrayList((Iterable)collection);
                    filter.filter(collection, bid, seatBid, attribute);
                    Set<Long> filterConfigIds = this.diff(temp, collection);
                    if (!CollectionUtils.isEmpty(filterConfigIds)) {
                        filterConfigMap.put(DispatcherPriceConfigFilterEnum.getTypeByClass(filter), filterConfigIds);
                    }
                });
                if (collection.size() != 1) {
                    log.debug("dispatcher {} price config size is {}", (Object)dispatcher.getId(), (Object)collection.size());
                    if (collection.size() == 0) {
                        throw new AdxException(AdxErrEnum.DISPATCHER_PRICE_CONFIG_NONE_ERR);
                    }
                    throw new AdxException(AdxErrEnum.DISPATCHER_PRICE_CONFIG_ERR);
                }
                Long dpcId = ((DispatcherPriceConfig)collection.iterator().next()).getPriceModeId();
                bid.setDpc_id(dpcId == null ? null : dpcId.toString());
                filterInfos.add(FilterInfo.builder().bid(bid).seatBid(seatBid).filterConfigMap(filterConfigMap).build());
            }
        }
        if (!CollectionUtils.isEmpty(filterInfos)) {
            this.eventPark.post((EventObject)new AdxDispatcherPriceConfigFilter(this, attribute.getBidRequest(), dispatcher, attribute.getAdxRequest(), attribute.getBuyer(), filterInfos));
        }
    }

    public Set<Long> diff(Collection<DispatcherPriceConfig> before, Collection<DispatcherPriceConfig> after) {
        return before.stream().filter(e -> !after.contains(e)).map(DispatcherPriceConfig::getPriceModeId).collect(Collectors.toSet());
    }
}

