/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.filter;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.filter.DispatcherPriceConfigFilter;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MaxExposureDispatcherPriceConfigFilter
implements DispatcherPriceConfigFilter {
    private static final Logger log = LoggerFactory.getLogger(MaxExposureDispatcherPriceConfigFilter.class);
    private final Fetcher fetcher;

    public MaxExposureDispatcherPriceConfigFilter(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    public int getOrder() {
        return 30;
    }

    @Override
    public void filter(Collection<DispatcherPriceConfig> priceConfigs, Bid bid, SeatBid seatBid, ResponseBuildAttribute attribute) {
        priceConfigs.removeIf(config -> config.getExposureFilterMode() != null && config.getExposureFilterMode() == 1 && this.getPositionDspExposure(attribute.getDispatcher(), (DispatcherPriceConfig)config) >= config.getExposureValue());
    }

    private int getPositionDspExposure(Dispatcher dispatcher, DispatcherPriceConfig config) {
        String configId = dispatcher.getConfigId().toString();
        String dspId = dispatcher.getDspId().toString();
        String dspTagId = dispatcher.getDspPosid();
        Long dpcId = config.getPriceModeId();
        if (dpcId == null) {
            log.warn("priceModeId is empty configId:{} - dspId:{} - dspTagId:{} - priceConfigId:{}", new Object[]{configId, dspId, dspTagId, config.getId()});
        }
        KeyGenerator keyGenerator = AdxKeyGenerator.Counter.getPositionDspExposure((String)configId, (String)dspId, (String)dspTagId, (String)(dpcId == null ? "" : dpcId.toString()));
        Long exposure = (Long)this.fetcher.fetch(keyGenerator, Long.class);
        return Objects.isNull(exposure) ? 0 : exposure.intValue();
    }
}

