/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.offer;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.offer.Offer;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferResult;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferType;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import java.math.BigDecimal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DspAvgPriceOffer
implements Offer {
    private static final Logger log = LoggerFactory.getLogger(DspAvgPriceOffer.class);

    @Override
    public OfferResult offer(Bid bid, BidRequest request, Dispatcher dispatcher, DispatcherPriceConfig priceConfig) {
        Integer bidModel = request.getBid_model();
        int chargeType = 1;
        int budgetType = 1;
        if (Objects.nonNull(bidModel)) {
            switch (bidModel) {
                case 2: {
                    chargeType = 2;
                    budgetType = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    Integer costType = priceConfig.getMediaCostType();
                    if (!Objects.nonNull(costType)) break;
                    if (costType == 2) {
                        chargeType = 2;
                        budgetType = 2;
                        break;
                    }
                    if (costType != 3) break;
                    chargeType = 3;
                    budgetType = 3;
                }
            }
        }
        OfferResult offerResult = OfferResult.builder().chargeType(chargeType).offer(this.getFixedPrice(dispatcher, priceConfig)).budgetType(budgetType).build();
        return offerResult;
    }

    @Override
    public OfferType offerType() {
        return OfferType.Dsp_Avg_Price;
    }

    private BigDecimal getFixedPrice(Dispatcher dispatcher, DispatcherPriceConfig dispatcherPriceConfig) {
        BigDecimal mediaOfferPrice;
        if (Objects.nonNull(dispatcherPriceConfig) && Objects.nonNull(mediaOfferPrice = dispatcherPriceConfig.getMediaOfferPrice())) {
            return mediaOfferPrice.movePointRight(2);
        }
        log.warn("dispatcher {} dsp-cpm empty", (Object)dispatcher.getId());
        return dispatcher.getDspAvgPrice().movePointRight(2);
    }
}

