/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.offer;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.offer.Offer;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferResult;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferType;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NoneDspAvgPriceOffer
implements Offer {
    private static final Logger log = LoggerFactory.getLogger(NoneDspAvgPriceOffer.class);

    @Override
    public OfferResult offer(Bid bid, BidRequest request, Dispatcher dispatcher, DispatcherPriceConfig priceConfig) {
        return OfferResult.builder().offer(this.getPriceByConfig(bid, request, priceConfig)).chargeType(1).budgetType(1).build();
    }

    @Override
    public OfferType offerType() {
        return OfferType.NONE_Dsp_Avg_Price;
    }

    private BigDecimal getPriceByConfig(Bid bid, BidRequest bidRequest, DispatcherPriceConfig config) {
        BigDecimal bidFloor;
        BigDecimal profitMargin;
        if (Objects.isNull(config)) {
            return bid.getPrice();
        }
        BigDecimal dspWinPrice = Optional.ofNullable(bid.getDspWinPrice()).orElse(Optional.ofNullable(bid.getDsp_dis_price()).orElse(bid.getDsp_price()));
        BigDecimal newPrice = dspWinPrice.multiply(new BigDecimal(100.0).subtract(profitMargin = Optional.ofNullable(config.getProfitMargin()).orElse(BigDecimal.ZERO))).multiply(config.getBiddingCoefficient()).movePointLeft(2);
        if (newPrice.compareTo(bidFloor = bidRequest.getImps().iterator().next().getBid_floor()) >= 0) {
            return newPrice.setScale(0, RoundingMode.HALF_UP);
        }
        BigDecimal explorePrice = bidFloor.add(BigDecimal.ONE);
        if (dspWinPrice.compareTo(explorePrice) >= 0) {
            return explorePrice.setScale(0, RoundingMode.HALF_UP);
        }
        return null;
    }

    @Deprecated
    private BigDecimal maxBidFloor(BidRequest bidRequest, Dispatcher dispatcher) {
        BigDecimal dispatcherBidFloor = Optional.ofNullable(dispatcher.getDspBasePrice()).orElse(BigDecimal.ZERO).movePointRight(2);
        BigDecimal bidFloor = bidRequest.getImps().iterator().next().getBid_floor();
        int result = bidFloor.compareTo(dispatcherBidFloor);
        switch (result) {
            case -1: {
                return dispatcherBidFloor;
            }
        }
        return bidFloor;
    }
}

