/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.request;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.position.AdvertPoint;
import com.bxm.adx.common.buy.position.AdvertPointService;
import com.bxm.adx.common.market.exchange.rebuild.request.AdxBidRequestBuilder;
import com.bxm.adx.common.market.exchange.rebuild.request.RequestBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.App;
import com.bxm.mccms.facade.model.pushable.SysDictCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.pair.Pair;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AppBuilder
implements AdxBidRequestBuilder {
    private final AdvertPointService advertPointService;
    private final Pair pair;
    private static final String KEY = "adx.app.package.dsp.list";
    private static final String DSP_TANX = "tanx";
    private final Fetcher fetcher;

    public AppBuilder(AdvertPointService advertPointService, Pair pair, Fetcher fetcher) {
        this.advertPointService = advertPointService;
        this.pair = pair;
        this.fetcher = fetcher;
    }

    @Override
    public void rebuildAdxBidRequest(BidRequest adxBidRequest, RequestBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getBuyerWrapper().getDispatcher();
        AdvertPoint advertPoint = this.advertPointService.getAdvertPointByDspId(dispatcher.getDspId().toString(), dispatcher.getDspAppid(), dispatcher.getDspPosid());
        App app = new App();
        if (Objects.nonNull(adxBidRequest.getApp())) {
            BeanUtils.copyProperties((Object)adxBidRequest.getApp(), (Object)app);
        }
        boolean pass = this.isPassThrough(dispatcher);
        app.setId(dispatcher.getDspAppid());
        Buyer buyer = attribute.getBuyerWrapper().getBuyer();
        this.rebuildAppInfo(app, pass, dispatcher, advertPoint, buyer);
        adxBidRequest.setApp(app);
    }

    private void rebuildAppInfo(App app, boolean pass, Dispatcher dispatcher, AdvertPoint advertPoint, Buyer buyer) {
        if (DSP_TANX.equals(buyer.getCode()) && StringUtils.isNotBlank((String)app.getBundle())) {
            KeyGenerator appCategoryKey;
            SysDictCacheVO categorySysDict;
            KeyGenerator appNameKey = CacheKeys.getAppNameSysDictKeyGenerator(app.getBundle());
            SysDictCacheVO sysDictCacheVO = (SysDictCacheVO)this.fetcher.fetch(appNameKey, SysDictCacheVO.class);
            if (Objects.nonNull(sysDictCacheVO)) {
                app.setName(sysDictCacheVO.getDictValue());
            }
            if (Objects.nonNull(categorySysDict = (SysDictCacheVO)this.fetcher.fetch(appCategoryKey = CacheKeys.getAppCatSysDictKeyGenerator(app.getBundle()), SysDictCacheVO.class))) {
                app.setCat(categorySysDict.getDictValue());
            }
            if (StringUtils.isBlank((String)app.getCat())) {
                app.setCat("1050");
            }
        }
        if (pass) {
            if (StringUtils.isEmpty((String)app.getBundle()) && StringUtils.isNotBlank((String)dispatcher.getAppPackageName())) {
                app.setBundle(dispatcher.getAppPackageName());
            }
            if (StringUtils.isEmpty((String)app.getName()) && Objects.nonNull(advertPoint) && StringUtils.isNotBlank((String)advertPoint.getAppName())) {
                app.setName(advertPoint.getAppName());
            }
            if (StringUtils.isEmpty((String)app.getVer()) && Objects.nonNull(advertPoint) && StringUtils.isNotBlank((String)advertPoint.getVersion())) {
                app.setVer(advertPoint.getVersion());
            }
        } else {
            if (DSP_TANX.equals(buyer.getCode()) && StringUtils.isNotBlank((String)app.getName())) {
                return;
            }
            if (Objects.nonNull(advertPoint)) {
                app.setVer(advertPoint.getVersion());
                app.setName(advertPoint.getAppName());
            }
            app.setId(dispatcher.getDspAppid());
            app.setBundle(dispatcher.getAppPackageName());
        }
    }

    private boolean isPassThrough(Dispatcher dispatcher) {
        String dspId;
        Set dspIds = this.pair.get(KEY).ofHashSet();
        return CollectionUtils.isNotEmpty((Collection)dspIds) && dspIds.contains(dspId = String.valueOf(dispatcher.getDspId()));
    }
}

