/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.market.exchange.rebuild.filter.DispatcherPriceConfigFilterFactory;
import com.bxm.adx.common.market.exchange.rebuild.response.AdxBidResponseBuilder;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidResponse;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

@Configuration
public class AdxBidResponseBuildFactory
implements ApplicationListener<ApplicationReadyEvent> {
    private List<AdxBidResponseBuilder> builderList = new ArrayList<AdxBidResponseBuilder>();
    private final DispatcherPriceConfigFilterFactory dispatcherPriceConfigFilterFactory;

    public AdxBidResponseBuildFactory(DispatcherPriceConfigFilterFactory dispatcherPriceConfigFilterFactory) {
        this.dispatcherPriceConfigFilterFactory = dispatcherPriceConfigFilterFactory;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.builderList.addAll(event.getApplicationContext().getBeansOfType(AdxBidResponseBuilder.class).values());
        this.builderList.sort(Comparator.comparingInt(Ordered::getOrder));
    }

    public BidResponse buildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        this.dispatcherPriceConfigFilterFactory.filter(bidResponse, attribute);
        this.builderList.forEach(builder -> builder.rebuildAdxBidResponse(bidResponse, attribute));
        return bidResponse;
    }

    private BidResponse initAdxBidResponse(BidResponse bidResponse) {
        BidResponse adxBidResponse = new BidResponse();
        BeanUtils.copyProperties((Object)bidResponse, (Object)adxBidResponse);
        return adxBidResponse;
    }
}

