/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.response.AdxBidResponseBuilder;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BidBuilder
implements AdxBidResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(BidBuilder.class);

    public int getOrder() {
        return 2;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getDispatcher();
        BidRequest adxRequest = attribute.getAdxRequest();
        Impression impression = adxRequest.getImps().iterator().next();
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                String dpcId;
                if (StringUtils.isEmpty((String)bid.getId())) {
                    bid.setId(RandomStringUtils.randomAlphabetic((int)8));
                }
                if (StringUtils.isEmpty((String)bid.getAdid())) {
                    bid.setAdid(RandomStringUtils.randomAlphanumeric((int)5));
                }
                if (StringUtils.isEmpty((String)bid.getTag_id())) {
                    bid.setTag_id(impression.getTag_id());
                }
                if (StringUtils.isEmpty((String)bid.getCreate_id())) {
                    bid.setCreate_id(RandomStringUtils.randomNumeric((int)7));
                }
                Integer chargeType = Optional.ofNullable(bid.getCharge_type()).orElse(1);
                bid.setCharge_type(chargeType);
                bid.setDsp_charge_type(chargeType);
                Integer budgetType = Optional.ofNullable(bid.getBudget_type()).orElse(1);
                bid.setBudget_type(budgetType);
                bid.setDsp_budget_type(budgetType);
                switch (budgetType) {
                    case 1: {
                        bid.setDsp_price(new BigDecimal(bid.getPrice().toString()));
                        break;
                    }
                    case 2: {
                        bid.setDsp_price(new BigDecimal(bid.getBid().toString()));
                    }
                }
                bid.setDsp_appid(dispatcher.getDspAppid());
                bid.setDsp_posid(dispatcher.getDspPosid());
                bid.setDspId(dispatcher.getDspId());
                if (Objects.isNull(bid.getImp_id())) {
                    bid.setImp_id(impression.getId());
                }
                if (Objects.isNull(bid.getType())) {
                    Integer type = Optional.ofNullable(AdxConstants.Type.getTypeByImpType(impression.getImp_type())).orElse(AdxConstants.Type.IMAGE.getType());
                    bid.setType(type);
                }
                if (StringUtils.isNotEmpty((String)(dpcId = bid.getDpc_id()))) {
                    Optional<DispatcherPriceConfig> optional = dispatcher.getDispatcherPriceConfigs().stream().filter(priceConfig -> priceConfig.getPriceModeId().toString().equals(dpcId)).findFirst();
                    if (optional.isPresent()) {
                        bid.setTrans_type(optional.get().getConversionTarget());
                        attribute.putBidPriceConfig(bid, optional.get());
                    } else {
                        log.warn("dispatcher {} dpcid {} config is null", (Object)dispatcher.getId(), (Object)dpcId);
                    }
                }
                if (!StringUtils.isBlank((String)bid.getBundle())) continue;
            }
        }
    }
}

