/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.response;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.AbstractPluginBuyModelAdapter;
import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.market.exchange.rebuild.response.AdxBidResponseBuilder;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ClickMonitor;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.device.SimpleDevice;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Configuration
public class ConversionBuilder
implements AdxBidResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConversionBuilder.class);
    private static final int PANGU_DSP_ID = 105;
    private static final int QIHANG_DSP_ID = 97;
    private final AdxProperties adxProperties;
    private final Pair pair;
    private static final String KEY = "adx.ocpx.conversion.map";

    public ConversionBuilder(AdxProperties adxProperties, Pair pair) {
        this.adxProperties = adxProperties;
        this.pair = pair;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        Buyer buyer = attribute.getBuyer();
        BuyModelAdapter adapter = buyer.getModelAdapter();
        if (!(adapter instanceof AbstractPluginBuyModelAdapter)) {
            return;
        }
        AbstractPluginBuyModelAdapter pluginAdapter = (AbstractPluginBuyModelAdapter)adapter;
        String macro = pluginAdapter.getPluginConfig().getProperties().getProperty("cburl");
        if (StringUtils.isBlank((CharSequence)macro)) {
            return;
        }
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                List<ClickMonitor> clickMonitors = bid.getClick_monitors();
                if (CollectionUtils.isEmpty(clickMonitors)) continue;
                clickMonitors.forEach(clickMonitor -> {
                    MultiValueMap<String, String> params = this.buildCustomizeParams(bidResponse, seatBid, bid, attribute);
                    String url = this.buildConversionUrl(params);
                    String click = clickMonitor.getClick_monitor_url().replace(macro, UrlHelper.urlEncode((String)url));
                    clickMonitor.setClick_monitor_url(click);
                });
            }
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private String buildConversionUrl(MultiValueMap<String, String> params) {
        String url = this.adxProperties.getOpenLog().createBase(51, params);
        return url;
    }

    private MultiValueMap<String, String> buildCustomizeParams(BidResponse bidResponse, SeatBid seatBid, Bid bid, ResponseBuildAttribute attribute) {
        LinkedMultiValueMap customizeParams = new LinkedMultiValueMap();
        String media = attribute.getBidRequest().getMediaId();
        String bundle = bid.getBundle();
        String bidid = attribute.getBidRequest().getId();
        String rt = System.currentTimeMillis() / 1000L + "";
        String device = this.getDevice(attribute);
        customizeParams.add((Object)"medid", (Object)media);
        customizeParams.add((Object)"bidid", (Object)bidid);
        customizeParams.add((Object)"advb", (Object)bundle);
        customizeParams.add((Object)"rt", (Object)rt);
        customizeParams.add((Object)"device", (Object)device);
        Long dspId = attribute.getBuyer().getDsp().getId();
        customizeParams.add((Object)"dspid", (Object)dspId.toString());
        customizeParams.add((Object)"conv_def", (Object)this.getConDef(Long.valueOf(media), dspId));
        return customizeParams;
    }

    private String getDevice(ResponseBuildAttribute attribute) {
        Device device = attribute.getBidRequest().getDevice();
        SimpleDevice simpleDevice = SimpleDevice.builder().imei(device.getImei()).imeiMd5(device.getImei_md5()).androidid(device.getDpid()).androididMd5(device.getDpid_md5()).oaid(device.getOaid()).oaidMd5(device.getOaid_md5()).idfa(device.getIdfa()).idfaMd5(device.getIdfa_md5()).gaid(device.getGaid()).gaidMd5(device.getGaid_md5()).ipv4(device.getIp()).ipv6(device.getIp_v6()).caid(device.getCaidInfoStr()).build();
        return SimpleDevice.Base64Cipher.encrypt((SimpleDevice)simpleDevice);
    }

    private String getConDef(Long mediaId, Long dspId) {
        List conversionDataList;
        Optional<ConversionData> optional;
        String config = this.pair.get(KEY).of();
        if (StringUtils.isNotBlank((CharSequence)config) && (optional = (conversionDataList = (List)JSON.parseObject((String)config, (TypeReference)new TypeReference<List<ConversionData>>(){}, (Feature[])new Feature[0])).stream().filter(conversionData -> dspId.equals(conversionData.getDspId()) && mediaId.equals(conversionData.getMediaId())).findFirst()).isPresent()) {
            return optional.get().getConvDef();
        }
        return "";
    }

    static class ConversionData {
        private Long mediaId;
        private Long dspId;
        private String convDef;

        public Long getMediaId() {
            return this.mediaId;
        }

        public Long getDspId() {
            return this.dspId;
        }

        public String getConvDef() {
            return this.convDef;
        }

        public void setMediaId(Long mediaId) {
            this.mediaId = mediaId;
        }

        public void setDspId(Long dspId) {
            this.dspId = dspId;
        }

        public void setConvDef(String convDef) {
            this.convDef = convDef;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConversionData)) {
                return false;
            }
            ConversionData other = (ConversionData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$mediaId = this.getMediaId();
            Long other$mediaId = other.getMediaId();
            if (this$mediaId == null ? other$mediaId != null : !((Object)this$mediaId).equals(other$mediaId)) {
                return false;
            }
            Long this$dspId = this.getDspId();
            Long other$dspId = other.getDspId();
            if (this$dspId == null ? other$dspId != null : !((Object)this$dspId).equals(other$dspId)) {
                return false;
            }
            String this$convDef = this.getConvDef();
            String other$convDef = other.getConvDef();
            return !(this$convDef == null ? other$convDef != null : !this$convDef.equals(other$convDef));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConversionData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $mediaId = this.getMediaId();
            result = result * 59 + ($mediaId == null ? 43 : ((Object)$mediaId).hashCode());
            Long $dspId = this.getDspId();
            result = result * 59 + ($dspId == null ? 43 : ((Object)$dspId).hashCode());
            String $convDef = this.getConvDef();
            result = result * 59 + ($convDef == null ? 43 : $convDef.hashCode());
            return result;
        }

        public String toString() {
            return "ConversionBuilder.ConversionData(mediaId=" + this.getMediaId() + ", dspId=" + this.getDspId() + ", convDef=" + this.getConvDef() + ")";
        }
    }

    static interface Macros {
        public static final String Advertiser = "dspid";
        public static final String Media = "medid";
        public static final String Bundle = "advb";
        public static final String Bidid = "bidid";
        public static final String RequestTime = "rt";
        public static final String Device = "device";
        public static final String ConversionDef = "conv_def";
    }
}

