/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.response;

import cn.hutool.core.collection.CollUtil;
import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.ReplaceCreativeProperties;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.creative.replace.ReplaceCreative;
import com.bxm.adx.common.creative.replace.ReplaceCreativeDao;
import com.bxm.adx.common.ip.IpService;
import com.bxm.adx.common.market.exchange.ExchangeContext;
import com.bxm.adx.common.market.exchange.rebuild.response.AdxBidResponseBuilder;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.response.Asset;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.Image;
import com.bxm.adx.common.sell.response.Native;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.common.sell.response.Text;
import com.bxm.adx.common.sell.response.Video;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Sets;
import java.net.URI;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NativeBuilder
implements AdxBidResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(NativeBuilder.class);
    private final ReplaceCreativeProperties replaceCreativeProperties;
    private final ReplaceCreativeDao replaceCreativeDao;
    private final IpService ipService;
    private final Pair pair;
    private static final String KEY = "adx.creative.no.replace.task.list";

    public NativeBuilder(ReplaceCreativeProperties replaceCreativeProperties, ReplaceCreativeDao replaceCreativeDao, IpService ipService, Pair pair) {
        this.replaceCreativeProperties = replaceCreativeProperties;
        this.replaceCreativeDao = replaceCreativeDao;
        this.ipService = ipService;
        this.pair = pair;
    }

    public int getOrder() {
        return 3;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        BidRequest request = attribute.getBidRequest();
        if (this.mediaLimit(request)) {
            return;
        }
        Set noReplaceTaskIds = this.pair.get(KEY).ofHashSet();
        Dispatcher dispatcher = attribute.getDispatcher();
        ReplaceCreative creative = this.getCreative(dispatcher);
        if (Objects.isNull(creative)) {
            return;
        }
        boolean isFullUse = this.isFullUse(request);
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                String taskId = bid.getTask_id();
                boolean noReplace = false;
                if (CollUtil.isNotEmpty((Collection)noReplaceTaskIds) && noReplaceTaskIds.contains(taskId)) {
                    noReplace = true;
                }
                log.debug("noReplaceTaskIds:{},taskId:{},noReplace:{}", new Object[]{noReplaceTaskIds, taskId, noReplace});
                Native an = bid.getA_native();
                if (!Objects.nonNull(creative) || !Objects.nonNull(an) || !CollectionUtils.isNotEmpty(an.getAssets())) continue;
                List<Asset> replaceAssetList = this.needReplace(an.getAssets(), request, creative, noReplace);
                if (isFullUse) {
                    an.setAssets(replaceAssetList);
                } else {
                    this.buildNative(an, replaceAssetList);
                }
                bid.setAdxCreateId(creative.getId().toString());
            }
        }
    }

    private boolean isFullUse(BidRequest request) {
        List<String> mediaIdList = this.replaceCreativeProperties.getFullUseMediaIdList();
        return CollectionUtils.isNotEmpty(mediaIdList) && mediaIdList.contains(request.getMediaId());
    }

    private ReplaceCreative getCreative(Dispatcher dispatcher) {
        List<ReplaceCreative> creatives = this.queryReplaceCreativeByDispatcher(dispatcher);
        ReplaceCreative creative = this.randomCreative(creatives);
        return creative;
    }

    private ReplaceCreative randomCreative(List<ReplaceCreative> creatives) {
        if (CollectionUtils.isNotEmpty(creatives)) {
            int r = RandomUtils.nextInt((int)creatives.size());
            return creatives.get(r);
        }
        return null;
    }

    private boolean mediaLimit(BidRequest request) {
        ReplaceCreativeProperties.LimitConfig config = this.replaceCreativeProperties.getLimitConfig();
        if (Objects.isNull(config)) {
            return false;
        }
        String mediaId = request.getMediaId();
        List<String> mediaIdList = config.getMediaIdList();
        return CollectionUtils.isNotEmpty(mediaIdList) && mediaIdList.contains(mediaId) && this.timeLimit() && this.regionalLimit(request, config);
    }

    private boolean timeLimit() {
        LocalTime dateTime = LocalTime.now();
        LocalTime startTime = LocalTime.of(9, 30);
        LocalTime endTime = LocalTime.of(18, 30);
        return dateTime.isAfter(startTime) && dateTime.isBefore(endTime);
    }

    private boolean regionalLimit(BidRequest request, ReplaceCreativeProperties.LimitConfig config) {
        List<String> provinceCodes = config.getProvinceCodeList();
        if (CollectionUtils.isEmpty(provinceCodes)) {
            return false;
        }
        IP ip = this.getIp(request);
        if (Objects.isNull(ip)) {
            return false;
        }
        if (ip.isHit()) {
            String hitcode = ip.getHitcode();
            String province = this.getCodeForProvince(hitcode);
            return provinceCodes.contains(province);
        }
        return false;
    }

    private IP getIp(BidRequest bidRequest) {
        String ip;
        Device device;
        IP ipp = ExchangeContext.getIp();
        if (Objects.nonNull(ipp)) {
            return ipp;
        }
        if (bidRequest != null && (device = bidRequest.getDevice()) != null && !org.springframework.util.StringUtils.isEmpty((Object)(ip = device.getIp()))) {
            ipp = this.ipService.analyze(ip);
            return ipp;
        }
        return ipp;
    }

    private String getCodeForProvince(String code) {
        return StringUtils.rightPad((String)StringUtils.left((String)code, (int)2), (int)6, (String)"0");
    }

    private List<ReplaceCreative> queryReplaceCreativeByDispatcher(Dispatcher dispatcher) {
        List<Long> creativeIds = dispatcher.getCreativeIdList();
        if (CollectionUtils.isNotEmpty(creativeIds)) {
            List<ReplaceCreative> creativeList = this.replaceCreativeDao.queryCreativeListByIds(creativeIds);
            return creativeList;
        }
        return null;
    }

    private String urlRequestTimeAuth(BidRequest request, String url) {
        ReplaceCreativeProperties.ErConfig erConfig = this.replaceCreativeProperties.getErConfig();
        if (Objects.isNull(erConfig)) {
            return url;
        }
        String mediaId = request.getMediaId();
        List<String> mediaIdList = erConfig.getMediaIdList();
        if (CollectionUtils.isEmpty(mediaIdList) || !mediaIdList.contains(mediaId)) {
            return url;
        }
        String host = erConfig.getNewHost();
        if (StringUtils.isBlank((String)host)) {
            return url;
        }
        return this.getNewUrl(url, host);
    }

    private String getNewUrl(String url, String newHost) {
        if (StringUtils.isNotBlank((String)url)) {
            URI uri = URI.create(url);
            String path = uri.getPath();
            long timestamp = System.currentTimeMillis() / 1000L;
            path = path.replace(".", "-" + timestamp + ".");
            return newHost + path;
        }
        return url;
    }

    private void buildNative(Native an, List<Asset> needReplace) {
        if (CollectionUtils.isEmpty(needReplace)) {
            return;
        }
        HashSet replacedTypes = Sets.newHashSet();
        ArrayList<Asset> newAsset = new ArrayList<Asset>();
        for (Asset asset2 : an.getAssets()) {
            Integer type = asset2.getType();
            if (Objects.isNull(type)) continue;
            Optional<Asset> replace = null;
            replace = type.equals(AdxConstants.AssetType.REWARDER_VIDEO.getType()) ? needReplace.stream().filter(a -> a.getType().equals(AdxConstants.AssetType.VIDEO.getType())).findFirst() : needReplace.stream().filter(a -> a.getType().equals(type)).findFirst();
            if (replace.isPresent()) {
                Asset replaceAsset = replace.get();
                replacedTypes.add(replaceAsset.getType());
                if (type.equals(AdxConstants.AssetType.VIDEO.getType()) || type.equals(AdxConstants.AssetType.REWARDER_VIDEO.getType())) {
                    Video oldVideo = asset2.getVideo();
                    Video newVideo = replaceAsset.getVideo();
                    if (Objects.nonNull(oldVideo)) {
                        newVideo.setV_monitor(oldVideo.getV_monitor());
                        if (Objects.nonNull(newVideo.getCover_url())) {
                            oldVideo.setCover_url(newVideo.getCover_url());
                        }
                        if (Objects.nonNull(newVideo.getW())) {
                            oldVideo.setW(newVideo.getW());
                        }
                        if (Objects.nonNull(newVideo.getH())) {
                            oldVideo.setH(newVideo.getH());
                        }
                        if (Objects.nonNull(newVideo.getDuration())) {
                            oldVideo.setDuration(newVideo.getDuration());
                        }
                        if (Objects.nonNull(newVideo.getMax_length())) {
                            oldVideo.setMax_length(newVideo.getMax_length());
                        }
                        if (Objects.nonNull(newVideo.getUrl())) {
                            oldVideo.setUrl(newVideo.getUrl());
                        }
                        if (Objects.nonNull(newVideo.getMime_types())) {
                            oldVideo.setMime_types(newVideo.getMime_types());
                        }
                    }
                    Asset newVideoAsset = Asset.builder().type(type).video(oldVideo).build();
                    newAsset.add(newVideoAsset);
                    continue;
                }
                Asset copyAsset = (Asset)JsonHelper.convert((String)JsonHelper.convert((Object)replaceAsset), Asset.class);
                newAsset.add(copyAsset);
                continue;
            }
            newAsset.add(asset2);
        }
        List needAdd = needReplace.stream().filter(asset -> !replacedTypes.contains(asset.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(needAdd)) {
            newAsset.addAll(needAdd);
        }
        an.setAssets(newAsset);
    }

    private List<Asset> needReplace(List<Asset> oldAssets, BidRequest request, ReplaceCreative creative, boolean noReplace) {
        Integer h;
        Integer w;
        String[] sizes;
        ArrayList<Asset> assets = new ArrayList<Asset>();
        Integer type = creative.getType();
        String title = creative.getTitle();
        String content = creative.getContent();
        String img = this.urlRequestTimeAuth(request, creative.getImageUrl());
        String icon = creative.getIconUrl();
        String source = creative.getSource();
        if (StringUtils.isNotEmpty((String)title)) {
            Asset titleAsset = Asset.builder().type(AdxConstants.AssetType.TITLE.getType()).text(Text.builder().text(title).build()).build();
            assets.add(titleAsset);
        }
        if (StringUtils.isNotEmpty((String)content)) {
            Asset contentAsset = Asset.builder().type(AdxConstants.AssetType.CONTENT.getType()).text(Text.builder().text(content).build()).build();
            assets.add(contentAsset);
        }
        if (StringUtils.isNotEmpty((String)source)) {
            Asset brandNameAsset = Asset.builder().type(AdxConstants.AssetType.BRAND_NAME.getType()).text(Text.builder().text(source).build()).build();
            assets.add(brandNameAsset);
        }
        if (StringUtils.isNotEmpty((String)img)) {
            String imageSize = creative.getImageSize();
            sizes = null;
            w = null;
            h = null;
            if (StringUtils.isNotEmpty((String)imageSize)) {
                try {
                    sizes = imageSize.split("\\*");
                    w = Integer.valueOf(sizes[0]);
                    h = Integer.valueOf(sizes[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (type.equals(1)) {
                if (noReplace) {
                    Optional<Asset> oldImgAsset = oldAssets.stream().filter(a -> Objects.nonNull(a) && Objects.nonNull(a.getType())).filter(a -> a.getType().equals(AdxConstants.AssetType.LARGE_IMG.getType())).findFirst();
                    oldImgAsset.ifPresent(assets::add);
                } else {
                    Asset imgAsset = Asset.builder().type(AdxConstants.AssetType.LARGE_IMG.getType()).img(Image.builder().h(h).w(w).url(img).build()).build();
                    assets.add(imgAsset);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)icon)) {
            String iconSize = creative.getIconSize();
            sizes = null;
            w = null;
            h = null;
            if (StringUtils.isNotEmpty((String)iconSize)) {
                try {
                    sizes = iconSize.split("\\*");
                    w = Integer.valueOf(sizes[0]);
                    h = Integer.valueOf(sizes[1]);
                }
                catch (Exception imgAsset) {
                    // empty catch block
                }
            }
            Asset iconAsset = Asset.builder().type(AdxConstants.AssetType.ICON.getType()).img(Image.builder().h(h).w(w).url(icon).build()).build();
            assets.add(iconAsset);
        }
        if (type.equals(2)) {
            String videoSize = creative.getVideoSize();
            sizes = null;
            w = null;
            h = null;
            if (StringUtils.isNotEmpty((String)videoSize)) {
                try {
                    sizes = videoSize.split("\\*");
                    w = Integer.valueOf(sizes[0]);
                    h = Integer.valueOf(sizes[1]);
                }
                catch (Exception iconAsset) {
                    // empty catch block
                }
            }
            Video video = Video.builder().w(w).h(h).duration(Objects.isNull(creative.getVideoTime()) ? null : Integer.valueOf(creative.getVideoTime() * 1000)).cover_url(img).mime_types(StringUtils.isNotBlank((String)creative.getVideoFormat()) ? Arrays.asList(creative.getVideoFormat()) : null).url(creative.getVideoUrl()).max_length(Objects.nonNull(creative.getVideoKb()) ? Integer.valueOf(creative.getVideoKb().intValue()) : null).build();
            Asset videoAsset = Asset.builder().video(video).type(AdxConstants.AssetType.VIDEO.getType()).build();
            assets.add(videoAsset);
        }
        return assets;
    }
}

