/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class ResponseBuildAttribute
implements Serializable {
    private static final long serialVersionUID = 1309553361486113841L;
    private BidRequest bidRequest;
    private Dispatcher dispatcher;
    private BidRequest adxRequest;
    private Buyer buyer;
    private Map<String, DispatcherPriceConfig> bidPriceConfigMap;

    public DispatcherPriceConfig getBidPriceConfig(Bid bid) {
        if (MapUtils.isEmpty(this.bidPriceConfigMap)) {
            return null;
        }
        return this.bidPriceConfigMap.get(this.buildKey(bid));
    }

    public DispatcherPriceConfig putBidPriceConfig(Bid bid, DispatcherPriceConfig config) {
        return this.bidPriceConfigMap.put(this.buildKey(bid), config);
    }

    private String buildKey(Bid bid) {
        return bid.getId() + "-" + bid.getAdid();
    }

    ResponseBuildAttribute(BidRequest bidRequest, Dispatcher dispatcher, BidRequest adxRequest, Buyer buyer, Map<String, DispatcherPriceConfig> bidPriceConfigMap) {
        this.bidRequest = bidRequest;
        this.dispatcher = dispatcher;
        this.adxRequest = adxRequest;
        this.buyer = buyer;
        this.bidPriceConfigMap = bidPriceConfigMap;
    }

    public static ResponseBuildAttributeBuilder builder() {
        return new ResponseBuildAttributeBuilder();
    }

    public BidRequest getBidRequest() {
        return this.bidRequest;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public BidRequest getAdxRequest() {
        return this.adxRequest;
    }

    public Buyer getBuyer() {
        return this.buyer;
    }

    public Map<String, DispatcherPriceConfig> getBidPriceConfigMap() {
        return this.bidPriceConfigMap;
    }

    public void setBidRequest(BidRequest bidRequest) {
        this.bidRequest = bidRequest;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void setAdxRequest(BidRequest adxRequest) {
        this.adxRequest = adxRequest;
    }

    public void setBuyer(Buyer buyer) {
        this.buyer = buyer;
    }

    public void setBidPriceConfigMap(Map<String, DispatcherPriceConfig> bidPriceConfigMap) {
        this.bidPriceConfigMap = bidPriceConfigMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseBuildAttribute)) {
            return false;
        }
        ResponseBuildAttribute other = (ResponseBuildAttribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BidRequest this$bidRequest = this.getBidRequest();
        BidRequest other$bidRequest = other.getBidRequest();
        if (this$bidRequest == null ? other$bidRequest != null : !((Object)this$bidRequest).equals(other$bidRequest)) {
            return false;
        }
        Dispatcher this$dispatcher = this.getDispatcher();
        Dispatcher other$dispatcher = other.getDispatcher();
        if (this$dispatcher == null ? other$dispatcher != null : !((Object)this$dispatcher).equals(other$dispatcher)) {
            return false;
        }
        BidRequest this$adxRequest = this.getAdxRequest();
        BidRequest other$adxRequest = other.getAdxRequest();
        if (this$adxRequest == null ? other$adxRequest != null : !((Object)this$adxRequest).equals(other$adxRequest)) {
            return false;
        }
        Buyer this$buyer = this.getBuyer();
        Buyer other$buyer = other.getBuyer();
        if (this$buyer == null ? other$buyer != null : !this$buyer.equals(other$buyer)) {
            return false;
        }
        Map<String, DispatcherPriceConfig> this$bidPriceConfigMap = this.getBidPriceConfigMap();
        Map<String, DispatcherPriceConfig> other$bidPriceConfigMap = other.getBidPriceConfigMap();
        return !(this$bidPriceConfigMap == null ? other$bidPriceConfigMap != null : !((Object)this$bidPriceConfigMap).equals(other$bidPriceConfigMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseBuildAttribute;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BidRequest $bidRequest = this.getBidRequest();
        result = result * 59 + ($bidRequest == null ? 43 : ((Object)$bidRequest).hashCode());
        Dispatcher $dispatcher = this.getDispatcher();
        result = result * 59 + ($dispatcher == null ? 43 : ((Object)$dispatcher).hashCode());
        BidRequest $adxRequest = this.getAdxRequest();
        result = result * 59 + ($adxRequest == null ? 43 : ((Object)$adxRequest).hashCode());
        Buyer $buyer = this.getBuyer();
        result = result * 59 + ($buyer == null ? 43 : $buyer.hashCode());
        Map<String, DispatcherPriceConfig> $bidPriceConfigMap = this.getBidPriceConfigMap();
        result = result * 59 + ($bidPriceConfigMap == null ? 43 : ((Object)$bidPriceConfigMap).hashCode());
        return result;
    }

    public String toString() {
        return "ResponseBuildAttribute(bidRequest=" + this.getBidRequest() + ", dispatcher=" + this.getDispatcher() + ", adxRequest=" + this.getAdxRequest() + ", buyer=" + this.getBuyer() + ", bidPriceConfigMap=" + this.getBidPriceConfigMap() + ")";
    }

    public static class ResponseBuildAttributeBuilder {
        private BidRequest bidRequest;
        private Dispatcher dispatcher;
        private BidRequest adxRequest;
        private Buyer buyer;
        private Map<String, DispatcherPriceConfig> bidPriceConfigMap;

        ResponseBuildAttributeBuilder() {
        }

        public ResponseBuildAttributeBuilder bidRequest(BidRequest bidRequest) {
            this.bidRequest = bidRequest;
            return this;
        }

        public ResponseBuildAttributeBuilder dispatcher(Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        public ResponseBuildAttributeBuilder adxRequest(BidRequest adxRequest) {
            this.adxRequest = adxRequest;
            return this;
        }

        public ResponseBuildAttributeBuilder buyer(Buyer buyer) {
            this.buyer = buyer;
            return this;
        }

        public ResponseBuildAttributeBuilder bidPriceConfigMap(Map<String, DispatcherPriceConfig> bidPriceConfigMap) {
            this.bidPriceConfigMap = bidPriceConfigMap;
            return this;
        }

        public ResponseBuildAttribute build() {
            return new ResponseBuildAttribute(this.bidRequest, this.dispatcher, this.adxRequest, this.buyer, this.bidPriceConfigMap);
        }

        public String toString() {
            return "ResponseBuildAttribute.ResponseBuildAttributeBuilder(bidRequest=" + this.bidRequest + ", dispatcher=" + this.dispatcher + ", adxRequest=" + this.adxRequest + ", buyer=" + this.buyer + ", bidPriceConfigMap=" + this.bidPriceConfigMap + ")";
        }
    }
}

