/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.monitor;

import com.bxm.adx.common.market.monitor.MonitorHandler;
import com.bxm.adx.common.report.ServerReportService;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.warcar.integration.pair.Pair;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class WinNoticeHandler
implements MonitorHandler {
    private static final Logger log = LoggerFactory.getLogger(WinNoticeHandler.class);
    private final ServerReportService serverReportService;
    private static final String WIN_NOTICE_DSP_LIST_KEY = "adx.win.notice.dsp";
    private final Pair pair;

    public WinNoticeHandler(ServerReportService serverReportService, Pair pair) {
        this.serverReportService = serverReportService;
        this.pair = pair;
    }

    @Override
    public void handler(BuildAttribute attribute) {
        Bid bid = attribute.getBid();
        if (Objects.isNull(bid) || StringUtils.isBlank((String)bid.getNurl())) {
            return;
        }
        Set dspIdList = this.pair.get(WIN_NOTICE_DSP_LIST_KEY).ofHashSet();
        String nurl = bid.getNurl();
        if (!CollectionUtils.isEmpty((Collection)dspIdList) && dspIdList.contains(String.valueOf(attribute.getDspId()))) {
            this.serverReportService.reportWinNoticeUrl(nurl);
        }
    }

    public int getOrder() {
        return 0;
    }
}

