/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.nbr;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.limiter.InsertExpireHandler;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.nbr.NoBidResponseHandler;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.warcar.cache.KeyGenerator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomUtils;

public class BidDeviceHandler
implements NoBidResponseHandler {
    private final InsertExpireHandler insertExpireHandler;

    public BidDeviceHandler(InsertExpireHandler insertExpireHandler) {
        this.insertExpireHandler = insertExpireHandler;
    }

    @Override
    public void handler(Deal ... deals) {
        if (ArrayUtils.isEmpty((Object[])deals)) {
            return;
        }
        KeyGenerator key = this.keyGenerator(deals);
        if (Objects.isNull(key)) {
            return;
        }
        for (Deal deal : deals) {
            long keyExpire;
            Long expireVal;
            String crowdPackId = this.crowdPackId(deal);
            if (StringUtils.isBlank((String)crowdPackId) || Objects.isNull(expireVal = deal.getBidResponse().getCdt()) || (keyExpire = expireVal - System.currentTimeMillis() / 1000L) <= 0L) continue;
            this.insertExpireHandler.insert(key, crowdPackId, String.valueOf(expireVal), (int)(keyExpire += (long)RandomUtils.nextInt((int)1, (int)600)));
        }
    }

    @Override
    public int nbr() {
        return 40002;
    }

    private String crowdPackId(Deal deal) {
        ArrayList configs = Lists.newArrayList((Object[])new Config[]{new Config()});
        Dispatcher dispatcher = deal.getDispatcher();
        Long dspId = dispatcher.getDspId();
        String tagId = dispatcher.getDspPosid();
        Optional<Config> optional = configs.stream().filter(config -> {
            Long configDspId = config.getDspId();
            String configTagId = config.getTagId();
            return dspId.equals(configDspId) && tagId.equals(configTagId);
        }).findFirst();
        if (optional.isPresent()) {
            return optional.get().getCrowId();
        }
        return "";
    }

    private KeyGenerator keyGenerator(Deal ... deals) {
        for (Deal deal : deals) {
            BidRequest request = deal.getBidRequest();
            if (!Objects.nonNull(request)) continue;
            return CacheKeys.getCrowdPackageNewKey(request.getDevice());
        }
        return null;
    }

    static class Config {
        private Long dspId = 97L;
        private String tagId = "bxm_djk_7";
        private String crowId = "185";

        public Long getDspId() {
            return this.dspId;
        }

        public String getTagId() {
            return this.tagId;
        }

        public String getCrowId() {
            return this.crowId;
        }

        public void setDspId(Long dspId) {
            this.dspId = dspId;
        }

        public void setTagId(String tagId) {
            this.tagId = tagId;
        }

        public void setCrowId(String crowId) {
            this.crowId = crowId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$dspId = this.getDspId();
            Long other$dspId = other.getDspId();
            if (this$dspId == null ? other$dspId != null : !((Object)this$dspId).equals(other$dspId)) {
                return false;
            }
            String this$tagId = this.getTagId();
            String other$tagId = other.getTagId();
            if (this$tagId == null ? other$tagId != null : !this$tagId.equals(other$tagId)) {
                return false;
            }
            String this$crowId = this.getCrowId();
            String other$crowId = other.getCrowId();
            return !(this$crowId == null ? other$crowId != null : !this$crowId.equals(other$crowId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $dspId = this.getDspId();
            result = result * 59 + ($dspId == null ? 43 : ((Object)$dspId).hashCode());
            String $tagId = this.getTagId();
            result = result * 59 + ($tagId == null ? 43 : $tagId.hashCode());
            String $crowId = this.getCrowId();
            result = result * 59 + ($crowId == null ? 43 : $crowId.hashCode());
            return result;
        }

        public String toString() {
            return "BidDeviceHandler.Config(dspId=" + this.getDspId() + ", tagId=" + this.getTagId() + ", crowId=" + this.getCrowId() + ")";
        }
    }
}

