/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.micrometer.aspect;

import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter;
import com.bxm.adx.common.micrometer.aspect.DispatcherFilterMicroMeter;
import io.micrometer.core.instrument.Timer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class DispatcherFilterMicroMeterAspect {
    private final DispatcherFilterMicroMeter microMeter;

    public DispatcherFilterMicroMeterAspect(DispatcherFilterMicroMeter microMeter) {
        this.microMeter = microMeter;
    }

    @Pointcut(value="this(com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter) && execution(* filter(..))")
    public void pointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof DispatcherFilter)) {
            return point.proceed();
        }
        DispatcherFilter filter = (DispatcherFilter)target;
        Timer timer = this.microMeter.get(filter);
        long start = System.nanoTime();
        try {
            Object object = point.proceed();
            return object;
        }
        finally {
            if (Objects.nonNull(timer)) {
                timer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
    }
}

