/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.micrometer.aspect;

import com.bxm.adx.common.filter.Filter;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class MarketOrderFilterMicroMeter
implements MeterBinder {
    private static final Logger log = LoggerFactory.getLogger(MarketOrderFilterMicroMeter.class);
    private final Map<Class, Timer> timers = Maps.newConcurrentMap();
    private final Iterable<Filter> filters;

    public MarketOrderFilterMicroMeter(Iterable<Filter> filters) {
        this.filters = filters;
    }

    public void bindTo(MeterRegistry registry) {
        for (Filter filter : this.filters) {
            Class clazz = ClassUtils.getUserClass((Object)filter);
            Timer timer = Timer.builder((String)"market.order.filter").tag("name", clazz.getName()).register(registry);
            this.timers.put(clazz, timer);
            log.info("Registering MarketOrder filter {} timer meter successful.", (Object)filter);
        }
    }

    Timer get(Filter filter) {
        return this.timers.get(ClassUtils.getUserClass((Object)filter));
    }
}

