/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.openlog.event.internal.AdxBidEvent;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Configuration
public class DotAdxBidEventListener
implements EventListener<AdxBidEvent> {
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public DotAdxBidEventListener(AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.properties = properties;
        this.macrosHandler = macrosHandler;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdxBidEvent event) {
        if (Math.abs(event.getSspRequest().getId().hashCode() % 100) >= this.properties.getDotSimplingPercent()) {
            return;
        }
        MultiValueMap<String, String> customizeParams = this.buildCustomizeParams(event.getAdxResponse());
        String url = this.properties.getOpenLog().create(true, 4, customizeParams, OpenlogConstants.WITHOUT_MACROS_INNER);
        Long dspId = event.getAdxResponse().getSeat_bid().iterator().next().getDspId();
        BuildAttribute attribute = new BuildAttribute(4).setDspId(dspId).setSspRequest(event.getSspRequest()).setAdxResponse(event.getAdxResponse()).setStrategyId(event.getAdxResponse().getSeat_bid().iterator().next().getStrategyId());
        url = this.macrosHandler.replaceAll(url, attribute);
        this.openLogClient.asyncRequest(url);
    }

    private MultiValueMap<String, String> buildCustomizeParams(BidResponse bidResponse) {
        LinkedMultiValueMap customizeParams = new LinkedMultiValueMap();
        List<Creative> creatives = this.getCreatives(bidResponse);
        String value = UrlHelper.urlEncode((String)JsonHelper.convert(creatives));
        customizeParams.add((Object)"creatives", (Object)value);
        return customizeParams;
    }

    private List<Creative> getCreatives(BidResponse bidResponse) {
        ArrayList<Creative> creatives = new ArrayList<Creative>();
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                String price = "";
                Integer budgetType = bid.getBudget_type();
                if (Objects.nonNull(budgetType)) {
                    switch (budgetType) {
                        case 1: {
                            price = bid.getPrice().toString();
                            break;
                        }
                        case 2: {
                            price = bid.getBid().toString();
                            break;
                        }
                        case 3: {
                            price = bid.getObid().toString();
                            break;
                        }
                    }
                }
                Creative creative = new Creative().setCreativeId(bid.getCreate_id()).setTicketId(bid.getAdid()).setBdgtyp(bid.getBudget_type()).setPrice(price).setTid(bid.getTask_id()).setDpcid(bid.getDpc_id()).setDspId(seatBid.getDspId()).setDappid(bid.getDsp_appid()).setDtagid(bid.getTag_id()).setConfigid(seatBid.getConfigId()).setUsl(bid.getUser_score_level());
                creatives.add(creative);
            }
        }
        return creatives;
    }

    private static class Creative {
        private String creativeId;
        private String ticketId;
        private String price;
        private String tid;
        private String dpcid;
        private Integer bdgtyp;
        private Long dspId;
        private String dappid;
        private String dtagid;
        private Long configid;
        private Integer usl;
        private Integer transType;

        public String getCreativeId() {
            return this.creativeId;
        }

        public String getTicketId() {
            return this.ticketId;
        }

        public String getPrice() {
            return this.price;
        }

        public String getTid() {
            return this.tid;
        }

        public String getDpcid() {
            return this.dpcid;
        }

        public Integer getBdgtyp() {
            return this.bdgtyp;
        }

        public Long getDspId() {
            return this.dspId;
        }

        public String getDappid() {
            return this.dappid;
        }

        public String getDtagid() {
            return this.dtagid;
        }

        public Long getConfigid() {
            return this.configid;
        }

        public Integer getUsl() {
            return this.usl;
        }

        public Integer getTransType() {
            return this.transType;
        }

        public Creative setCreativeId(String creativeId) {
            this.creativeId = creativeId;
            return this;
        }

        public Creative setTicketId(String ticketId) {
            this.ticketId = ticketId;
            return this;
        }

        public Creative setPrice(String price) {
            this.price = price;
            return this;
        }

        public Creative setTid(String tid) {
            this.tid = tid;
            return this;
        }

        public Creative setDpcid(String dpcid) {
            this.dpcid = dpcid;
            return this;
        }

        public Creative setBdgtyp(Integer bdgtyp) {
            this.bdgtyp = bdgtyp;
            return this;
        }

        public Creative setDspId(Long dspId) {
            this.dspId = dspId;
            return this;
        }

        public Creative setDappid(String dappid) {
            this.dappid = dappid;
            return this;
        }

        public Creative setDtagid(String dtagid) {
            this.dtagid = dtagid;
            return this;
        }

        public Creative setConfigid(Long configid) {
            this.configid = configid;
            return this;
        }

        public Creative setUsl(Integer usl) {
            this.usl = usl;
            return this;
        }

        public Creative setTransType(Integer transType) {
            this.transType = transType;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Creative)) {
                return false;
            }
            Creative other = (Creative)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$bdgtyp = this.getBdgtyp();
            Integer other$bdgtyp = other.getBdgtyp();
            if (this$bdgtyp == null ? other$bdgtyp != null : !((Object)this$bdgtyp).equals(other$bdgtyp)) {
                return false;
            }
            Long this$dspId = this.getDspId();
            Long other$dspId = other.getDspId();
            if (this$dspId == null ? other$dspId != null : !((Object)this$dspId).equals(other$dspId)) {
                return false;
            }
            Long this$configid = this.getConfigid();
            Long other$configid = other.getConfigid();
            if (this$configid == null ? other$configid != null : !((Object)this$configid).equals(other$configid)) {
                return false;
            }
            Integer this$usl = this.getUsl();
            Integer other$usl = other.getUsl();
            if (this$usl == null ? other$usl != null : !((Object)this$usl).equals(other$usl)) {
                return false;
            }
            Integer this$transType = this.getTransType();
            Integer other$transType = other.getTransType();
            if (this$transType == null ? other$transType != null : !((Object)this$transType).equals(other$transType)) {
                return false;
            }
            String this$creativeId = this.getCreativeId();
            String other$creativeId = other.getCreativeId();
            if (this$creativeId == null ? other$creativeId != null : !this$creativeId.equals(other$creativeId)) {
                return false;
            }
            String this$ticketId = this.getTicketId();
            String other$ticketId = other.getTicketId();
            if (this$ticketId == null ? other$ticketId != null : !this$ticketId.equals(other$ticketId)) {
                return false;
            }
            String this$price = this.getPrice();
            String other$price = other.getPrice();
            if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
                return false;
            }
            String this$tid = this.getTid();
            String other$tid = other.getTid();
            if (this$tid == null ? other$tid != null : !this$tid.equals(other$tid)) {
                return false;
            }
            String this$dpcid = this.getDpcid();
            String other$dpcid = other.getDpcid();
            if (this$dpcid == null ? other$dpcid != null : !this$dpcid.equals(other$dpcid)) {
                return false;
            }
            String this$dappid = this.getDappid();
            String other$dappid = other.getDappid();
            if (this$dappid == null ? other$dappid != null : !this$dappid.equals(other$dappid)) {
                return false;
            }
            String this$dtagid = this.getDtagid();
            String other$dtagid = other.getDtagid();
            return !(this$dtagid == null ? other$dtagid != null : !this$dtagid.equals(other$dtagid));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Creative;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $bdgtyp = this.getBdgtyp();
            result = result * 59 + ($bdgtyp == null ? 43 : ((Object)$bdgtyp).hashCode());
            Long $dspId = this.getDspId();
            result = result * 59 + ($dspId == null ? 43 : ((Object)$dspId).hashCode());
            Long $configid = this.getConfigid();
            result = result * 59 + ($configid == null ? 43 : ((Object)$configid).hashCode());
            Integer $usl = this.getUsl();
            result = result * 59 + ($usl == null ? 43 : ((Object)$usl).hashCode());
            Integer $transType = this.getTransType();
            result = result * 59 + ($transType == null ? 43 : ((Object)$transType).hashCode());
            String $creativeId = this.getCreativeId();
            result = result * 59 + ($creativeId == null ? 43 : $creativeId.hashCode());
            String $ticketId = this.getTicketId();
            result = result * 59 + ($ticketId == null ? 43 : $ticketId.hashCode());
            String $price = this.getPrice();
            result = result * 59 + ($price == null ? 43 : $price.hashCode());
            String $tid = this.getTid();
            result = result * 59 + ($tid == null ? 43 : $tid.hashCode());
            String $dpcid = this.getDpcid();
            result = result * 59 + ($dpcid == null ? 43 : $dpcid.hashCode());
            String $dappid = this.getDappid();
            result = result * 59 + ($dappid == null ? 43 : $dappid.hashCode());
            String $dtagid = this.getDtagid();
            result = result * 59 + ($dtagid == null ? 43 : $dtagid.hashCode());
            return result;
        }

        public String toString() {
            return "DotAdxBidEventListener.Creative(creativeId=" + this.getCreativeId() + ", ticketId=" + this.getTicketId() + ", price=" + this.getPrice() + ", tid=" + this.getTid() + ", dpcid=" + this.getDpcid() + ", bdgtyp=" + this.getBdgtyp() + ", dspId=" + this.getDspId() + ", dappid=" + this.getDappid() + ", dtagid=" + this.getDtagid() + ", configid=" + this.getConfigid() + ", usl=" + this.getUsl() + ", transType=" + this.getTransType() + ")";
        }
    }
}

