/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.openlog.event.internal.AdxFilterEvent;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Configuration
public class DotAdxFilterEventListener
implements EventListener<AdxFilterEvent> {
    private static final Logger log = LoggerFactory.getLogger(DotAdxFilterEventListener.class);
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public DotAdxFilterEventListener(AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.properties = properties;
        this.macrosHandler = macrosHandler;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdxFilterEvent event) {
        if (Math.abs(event.getSspRequest().getId().hashCode() % 100) >= this.properties.getDotSimplingPercent()) {
            return;
        }
        Map<Integer, Set<Deal>> trash = event.getTrashMap();
        List<FilterEntity> filterEntities = this.getFilterEntity(trash);
        LinkedMultiValueMap customizeParams = new LinkedMultiValueMap();
        String value = UrlHelper.urlEncode((String)JsonHelper.convert(filterEntities));
        customizeParams.add((Object)"fil", (Object)value);
        String url = this.properties.getOpenLog().create(true, 41, (MultiValueMap<String, String>)customizeParams, OpenlogConstants.WITHOUT_MACROS_INNER);
        BuildAttribute attribute = new BuildAttribute(41).setSspRequest(event.getSspRequest());
        url = this.macrosHandler.replaceAll(url, attribute);
        if (log.isDebugEnabled()) {
            log.debug("url: {}", (Object)url);
        }
        this.openLogClient.asyncRequest(url);
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    public List<FilterEntity> getFilterEntity(Map<Integer, Set<Deal>> trash) {
        ArrayList<FilterEntity> filterEntities = new ArrayList<FilterEntity>();
        for (Map.Entry<Integer, Set<Deal>> entry : trash.entrySet()) {
            for (Deal deal : entry.getValue()) {
                filterEntities.add(new FilterEntity().setType(entry.getKey()).setDspid(deal.getDispatcher().getDspId()).setDtagid(deal.getDispatcher().getDspPosid()).setDappid(deal.getDispatcher().getDspAppid()).setErrResult(Objects.isNull(deal.getAdxErrEnum()) ? null : deal.getAdxErrEnum().getResult()));
            }
        }
        return filterEntities;
    }

    static class FilterEntity {
        private int type;
        private Long dspid;
        private String dtagid;
        private String dappid;
        private Integer errResult;

        public int getType() {
            return this.type;
        }

        public Long getDspid() {
            return this.dspid;
        }

        public String getDtagid() {
            return this.dtagid;
        }

        public String getDappid() {
            return this.dappid;
        }

        public Integer getErrResult() {
            return this.errResult;
        }

        public FilterEntity setType(int type) {
            this.type = type;
            return this;
        }

        public FilterEntity setDspid(Long dspid) {
            this.dspid = dspid;
            return this;
        }

        public FilterEntity setDtagid(String dtagid) {
            this.dtagid = dtagid;
            return this;
        }

        public FilterEntity setDappid(String dappid) {
            this.dappid = dappid;
            return this;
        }

        public FilterEntity setErrResult(Integer errResult) {
            this.errResult = errResult;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FilterEntity)) {
                return false;
            }
            FilterEntity other = (FilterEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getType() != other.getType()) {
                return false;
            }
            Long this$dspid = this.getDspid();
            Long other$dspid = other.getDspid();
            if (this$dspid == null ? other$dspid != null : !((Object)this$dspid).equals(other$dspid)) {
                return false;
            }
            Integer this$errResult = this.getErrResult();
            Integer other$errResult = other.getErrResult();
            if (this$errResult == null ? other$errResult != null : !((Object)this$errResult).equals(other$errResult)) {
                return false;
            }
            String this$dtagid = this.getDtagid();
            String other$dtagid = other.getDtagid();
            if (this$dtagid == null ? other$dtagid != null : !this$dtagid.equals(other$dtagid)) {
                return false;
            }
            String this$dappid = this.getDappid();
            String other$dappid = other.getDappid();
            return !(this$dappid == null ? other$dappid != null : !this$dappid.equals(other$dappid));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FilterEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getType();
            Long $dspid = this.getDspid();
            result = result * 59 + ($dspid == null ? 43 : ((Object)$dspid).hashCode());
            Integer $errResult = this.getErrResult();
            result = result * 59 + ($errResult == null ? 43 : ((Object)$errResult).hashCode());
            String $dtagid = this.getDtagid();
            result = result * 59 + ($dtagid == null ? 43 : $dtagid.hashCode());
            String $dappid = this.getDappid();
            result = result * 59 + ($dappid == null ? 43 : $dappid.hashCode());
            return result;
        }

        public String toString() {
            return "DotAdxFilterEventListener.FilterEntity(type=" + this.getType() + ", dspid=" + this.getDspid() + ", dtagid=" + this.getDtagid() + ", dappid=" + this.getDappid() + ", errResult=" + this.getErrResult() + ")";
        }
    }
}

