/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.revealbottom;

import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.positionassembly.PositionAssembly;
import com.bxm.adx.common.buy.positionassembly.PositionAssemblyService;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.plugin.PluginHolder;
import com.bxm.adx.common.revealbottom.RevealBottom;
import com.bxm.adx.common.revealbottom.RevealBottomDsp;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Primary
@Configuration
public class DefaultRevealBottomImpl
implements RevealBottom {
    private static final Logger log = LoggerFactory.getLogger(DefaultRevealBottomImpl.class);
    private final PluginHolder pluginHolder;
    private final PositionService positionService;
    private final PositionAssemblyService positionAssemblyService;

    protected DefaultRevealBottomImpl(PluginHolder pluginHolder, PositionService positionService, PositionAssemblyService positionAssemblyService) {
        this.pluginHolder = pluginHolder;
        this.positionService = positionService;
        this.positionAssemblyService = positionAssemblyService;
    }

    @Override
    public Buyer getBuyer(RevealBottomDsp revealBottomDsp) {
        Map<String, Buyer> buyers = this.pluginHolder.getBuyers();
        return buyers.get(revealBottomDsp.getDspCode());
    }

    @Override
    public List<Deal> exchange(MarketOrders orders) {
        if (null == orders.getBidRequest() || null == orders.getPositions()) {
            return Collections.emptyList();
        }
        BidRequest request = orders.getBidRequest();
        List<Position> positions = orders.getPositions();
        ArrayList imps = Lists.newArrayList(request.getImps());
        BidRequest bidRequest = new BidRequest();
        BeanUtils.copyProperties((Object)request, (Object)bidRequest);
        bidRequest.setImps(imps);
        HashMap<String, Position> positionMap = new HashMap<String, Position>();
        for (Position position : positions) {
            PositionAssembly positionAssembly;
            if (!position.isRevealBottomAssembly() || null == (positionAssembly = this.positionAssemblyService.getByPositionId(position.getPositionId())) || !positionAssembly.isEnable()) continue;
            positionMap.put(position.getAppPositionId(), position);
        }
        imps.removeIf(imp -> {
            Position position = (Position)positionMap.get(imp.getTag_id());
            if (null != position) {
                imp.setTag_id(position.getPositionId());
                return false;
            }
            return true;
        });
        if (CollectionUtils.isEmpty((Collection)imps)) {
            return Collections.emptyList();
        }
        RevealBottomDsp revealBottomDsp = RevealBottomDsp.BXM_ASSEMBLY;
        return this.getDeal(bidRequest, revealBottomDsp);
    }

    private List<Deal> getDeal(BidRequest bidRequest, RevealBottomDsp revealBottomDsp) {
        Buyer buyer = this.getBuyer(revealBottomDsp);
        BuyModelAdapter modelAdapter = buyer.getModelAdapter();
        if (null == modelAdapter) {
            log.warn("BuyModelAdapter [{}] not found!", (Object)revealBottomDsp.getDspCode());
            return null;
        }
        byte[] request = modelAdapter.buildRequest(bidRequest);
        byte[] response = buyer.offer(request);
        return Lists.newArrayList((Object[])new Deal[]{new Deal(buyer, request, response, bidRequest)});
    }
}

