/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.position.cached;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionChangeHandler;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PositionCached
implements PositionChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(PositionCached.class);
    private final AdxProperties properties;
    private final ConcurrentHashMap<String, Position> positionIdMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Position> mediaPositionIdMap = new ConcurrentHashMap();

    public PositionCached(AdxProperties properties) {
        this.properties = properties;
    }

    @Override
    public void doUpdate(Position old, Position latest) {
        if (this.isExecuteUpdateAndDoDelete(old, latest)) {
            this.positionIdMap.put(latest.getPositionId(), latest);
            String mediaPositionId = latest.getAppPositionId();
            if (StringUtils.isNotEmpty((String)mediaPositionId)) {
                for (String tmp : mediaPositionId.split(",")) {
                    if (!StringUtils.isNotEmpty((String)tmp)) continue;
                    this.mediaPositionIdMap.put(tmp, latest);
                }
            }
        }
    }

    @Override
    public void doDelete(Position old) {
        this.positionIdMap.remove(old.getPositionId());
        String mediaPositionId = old.getAppPositionId();
        if (StringUtils.isNotEmpty((String)mediaPositionId)) {
            for (String tmp : mediaPositionId.split(",")) {
                if (!StringUtils.isNotEmpty((String)tmp)) continue;
                this.mediaPositionIdMap.remove(tmp);
            }
        }
    }

    public Position getPositionByTagId(String tagId) {
        return Optional.ofNullable(this.positionIdMap.get(tagId)).orElse(this.mediaPositionIdMap.get(tagId));
    }

    public Position getPositionById(String positionId) {
        return this.positionIdMap.get(positionId);
    }

    public Position getPositionByAppTagId(String positionId) {
        return this.mediaPositionIdMap.get(positionId);
    }

    @Deprecated
    private boolean isBesPosition(Position position) {
        if (!org.springframework.util.StringUtils.isEmpty((Object)position.getPositionSize())) {
            if (position.getAppId().equals(this.properties.getBesAndroidAppId())) {
                return true;
            }
            if (position.getAppId().equals(this.properties.getBesIosAppId())) {
                return true;
            }
        }
        return false;
    }
}

