/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.position.verify;

import com.bxm.adx.common.sell.app.AppService;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.verify.AbstractVerify;
import com.bxm.adx.common.sell.position.verify.Context;
import com.bxm.adx.facade.rule.app.App;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AppVerify
extends AbstractVerify {
    private static final Logger log = LoggerFactory.getLogger(AppVerify.class);
    private final AppService appService;

    public AppVerify(AppService appService) {
        this.appService = appService;
    }

    @Override
    public void verify(Context context) {
        if (context.isResult()) {
            return;
        }
        Position position = context.getPosition();
        String appId = position.getAppId();
        App app = this.appService.getAppById(appId);
        if (app == null) {
            if (log.isDebugEnabled()) {
                log.debug("pid = {}, app is null", (Object)position.getPositionId());
            }
            return;
        }
        String aid = context.getAppId();
        if (!StringUtils.isEmpty((Object)context.getSdkVer()) && this.isNeedVerifyAppId(context.getSdkVer())) {
            if (StringUtils.isEmpty((Object)aid)) {
                if (log.isDebugEnabled()) {
                    log.debug("pid = {}, aid is null", (Object)position.getPositionId());
                }
                return;
            }
            if (!appId.equalsIgnoreCase(aid)) {
                if (log.isDebugEnabled()) {
                    log.debug("pid = {}, appid is unequal", (Object)position.getPositionId());
                }
                return;
            }
        }
        String packageName = context.getPackageName();
        String appPackageName = app.getAppPackageName();
        if (StringUtils.isEmpty((Object)appPackageName)) {
            if (log.isWarnEnabled()) {
                log.warn("pid = {}, appPackageName is null", (Object)position.getPositionId());
            }
            return;
        }
        if (!appPackageName.equalsIgnoreCase(packageName)) {
            if (log.isWarnEnabled()) {
                log.warn("pid = {}, packageName is unequal", (Object)position.getPositionId());
            }
            return;
        }
        context.setResult(true);
    }
}

