/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sysdict;

import com.bxm.adx.common.sysdict.SysDictDao;
import com.bxm.mccms.facade.model.pushable.SysDictCacheVO;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CachePush(value="SYS_DICT")
public class SysDictDaoImpl
implements SysDictDao,
Pushable {
    private static final Logger log = LoggerFactory.getLogger(SysDictDaoImpl.class);
    private final DataSyncProducer dataSyncProducer;
    private final Updater updater;

    public SysDictDaoImpl(DataSyncProducer dataSyncProducer, Updater updater) {
        this.dataSyncProducer = dataSyncProducer;
        this.updater = updater;
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        SysDictCacheVO sysDictCacheVO;
        if (log.isInfoEnabled()) {
            log.info("sysdict data = {}", JsonHelper.convert((byte[])data, String.class));
        }
        if (Objects.isNull(sysDictCacheVO = (SysDictCacheVO)JsonHelper.convert((byte[])data, SysDictCacheVO.class)) || Objects.isNull(sysDictCacheVO.getId())) {
            return;
        }
        if (!"package_name".equals(sysDictCacheVO.getParentDictValue()) || !"tanx_category".equals(sysDictCacheVO.getParentDictValue())) {
            return;
        }
        String key = sysDictCacheVO.getClass().getName() + "$" + sysDictCacheVO.getId();
        this.dataSyncProducer.post(key, (Object)sysDictCacheVO);
        this.updater.update(this.getKeyGenerator(sysDictCacheVO.getParentDictValue(), sysDictCacheVO.getDictName()), (Object)sysDictCacheVO);
    }

    private KeyGenerator getKeyGenerator(String parentDictValue, String dictName) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "SYS_DICT", parentDictValue, dictName});
    }
}

