package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.rule.Rule;
import com.bxm.adx.common.creative.replace.ReplaceCreative;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

import static com.bxm.adx.common.AdxConstants.NO;
import static com.bxm.adx.common.AdxConstants.YES;

/**
 * @author allen
 * @since 2019-12-16
 */
@Data
public class Dispatcher implements Id {

    public static final byte DISPATCHER_OPENED_YES = YES;
    public static final byte DISPATCHER_OPENED_NO = NO;

    private Long id;
    private String positionId;
    private Long dspId;
    private String dspPosid;
    private String dspAppid;
    private int priority;
    /**
     * 返回优先级,1~5升序
     */
    private Integer returnPriority;
    private BigDecimal dspBasePrice;
    private byte opened;
    /**
     * 频次控制
     */
    private Integer frequency;
    /**
     * 平均CPM价
     */
    private BigDecimal dspAvgPrice;
    /**
     * 配置ID
     */
    private Long configId;
    /**
     * 应用包名
     */
    private String appPackageName;

    /**
     * 利润率
     */
    private BigDecimal profitMargin;

    /**
     * 曝光上限
     */
    private Integer maxExposure;

    /**
     * 关联的素材列表
     */
    private List<ReplaceCreative> creativeList;

    /**
     * 面向下游（流量方）的出价类型
     * @see com.bxm.mccms.facade.enums.OfferSettle
     */
    private String mediaSettle;

    /**
     * 安装包名定向
     */
    private Rule installedAppDirect;

    /**
     * 媒体包名定向
     */
    private Rule mediaAppDirect;

    /**
     * 关联的素材id列表
     */
    private List<Long> creativeIdList;

    /**
     * dsp出价配置明细
     */
    private List<DispatcherPriceConfig> dispatcherDspPosPriceConfigVOS;

    /**
     * 当前时段dsp出价配置明细
     */
    private DispatcherPriceConfig dispatcherPriceConfig;

    /**
     * 人群包定向,多个逗号分隔 示例："1,2&3" 1,2是白，3是黑
     */
    private Rule crowdPackageOrientation;

    /**
     * 频次控制
     */
    private Rule frequencys;

    /**
     * 设备字段控制
     */
    private Rule deviceInfo;

    /**
     * 地域控制
     */
    private Rule citys;

    /**
     * 探针 示例 0.01 = 1%
     */
    private BigDecimal probe;

    /**
     * 媒体ID定向
     */
    private Rule mediaIdDirect;


    @Override
    public String getId() {
        return String.valueOf(id);
    }

    /**
     * @return 是否开启流量分发
     */
    public boolean isOpened() {
        return opened == DISPATCHER_OPENED_YES;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Dispatcher that = (Dispatcher) o;
        return getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
