package com.bxm.adx.common.buy.dispatcher.filter;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.limiter.DeleteExpiredHandler;
import com.bxm.warcar.cache.Fetcher;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author fgf
 * @date 2023/3/23
 **/
@Slf4j
public class BlackCrowdPackageFilter extends AbstractCrowdPackageFilter {

    public BlackCrowdPackageFilter(Fetcher fetcher, DeleteExpiredHandler deleteExpiredHandler) {
        super(fetcher, deleteExpiredHandler);
    }

    @Override
    public void filter(DispatcherContext<Dispatcher> context, Set<Id> trash) {
        Collection<Dispatcher> dispatchers = context.getValues();
        //配置人群包定向的流量分配
        Set<Dispatcher> crowdPackageDispatchers = dispatchers.stream()
                .filter(dispatcher -> Objects.nonNull(dispatcher.getCrowdPackageOrientation()))
                .collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(crowdPackageDispatchers)) {
            return;
        }
        //用户命中的人群包
        Set<String> userCrowdSet = getUserCrowdPackageSet(context);
        Set<Dispatcher> remove = Sets.newHashSet();
        for (Dispatcher dispatcher : crowdPackageDispatchers) {
            Set<String> black = dispatcherBlackCrowdIds.get(dispatcher.getId());
            //黑名单命中
            if (hit(userCrowdSet, black)) {
                remove.add(dispatcher);
                continue;
            }
        }

        if (CollectionUtils.isNotEmpty(remove)) {
            trash.addAll(remove);
        }
    }

    @Override
    public int getOrder() {
        return 3;
    }
}
