package com.bxm.adx.common.buy.dispatcher.filter;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.rule.Rule;
import com.bxm.adx.common.rule.AndOrSetRule;
import com.bxm.adx.common.sell.request.Device;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

import java.lang.reflect.Field;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author fgf
 * @date 2023/3/13
 **/
@DispatcherFilterCondition(probeOn = true)
@Slf4j
@Configuration
public class DeviceFilter implements DispatcherFilter<Dispatcher> {
    private static final Set<String> DEVICE_ID_NAMES = Sets.newHashSet("imei", "idfa", "oaid", "gaid");
    @Override
    public void filter(DispatcherContext<Dispatcher> context, Set<Id> trash) {
        Device device = context.getRequest().getDevice();
        Set<Dispatcher> removes = context.getValues().stream().filter(dispatcher -> limitByDevice(dispatcher, device))
                .collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(removes)) {
            trash.addAll(removes);
        }
    }

    @Override
    public int getOrder() {
        return 1;
    }

    private boolean limitByDevice(Dispatcher dispatcher, Device device) {
        Rule deviceRule = dispatcher.getDeviceInfo();
        if (Objects.isNull(deviceRule)) {
            return false;
        }
        AndOrSetRule andOrSetRule = new AndOrSetRule(deviceRule);
        Set<String> paramNames = andOrSetRule.getAndParamNameSet();
        for (String paramName : paramNames) {
            if (andOrSetRule.isOrParams(paramName)) {
                Set<String> orParams = andOrSetRule.getOrParamNameSet(paramName);
                if (CollectionUtils.isEmpty(orParams)) {
                    continue;
                }
                boolean orLimit = false;
                for (String orParamName : orParams) {
                    if (hasFieldVal(device, orParamName)) {
                        orLimit = true;
                        break;
                    }
                }
                if (!orLimit) {
                    return true;
                }
            } else {
                if (!hasFieldVal(device, paramName)) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 反射获取属性名对应的value
     * 如果是设备ID相关字段还需要查询md5的属性值
     * @param device
     * @param fieldName
     * @return
     */
    private boolean hasFieldVal(Device device, String fieldName) {
        List<String> fieldNames = new ArrayList<>();
        fieldNames.add(fieldName);
        if (DEVICE_ID_NAMES.contains(fieldName)) {
            fieldNames.add(fieldName+"_md5");
        }
        try {
            Class cla = device.getClass();
            for (String name : fieldNames) {
                Field field = cla.getDeclaredField(name);
                field.setAccessible(true);
                Object val = field.get(device);
                if (log.isDebugEnabled()) {
                    log.debug("check device param {} val {}", name, Optional.ofNullable(val).orElse(null));
                }
                boolean hasVal = Objects.nonNull(val) && StringUtils.isNotBlank(val.toString());
                if (hasVal) {
                    return true;
                }
            }
        } catch (Exception e) {
        }
        return false;
    }
}
