package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.MarketRequest;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.request.Impression;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * @author allen
 * @since 2019-12-18
 */
@Slf4j
@Configuration
public class DefaultPriorityExchanger implements PriorityExchanger {

    private final Exchanger exchanger;

    public DefaultPriorityExchanger(Exchanger exchanger) {
        this.exchanger = exchanger;
    }

    @Override
    public ExchangeResult exchange(MarketOrders orders) {
        BidRequest request = orders.getBidRequest();
        List<MarketRequest> requestList = orders.getRequests();
        if (CollectionUtils.isEmpty(requestList)) {
            return null;
        }
        ExchangeResult exchangeResult = new ExchangeResult();
        for (MarketRequest marketRequest : requestList) {
            Set<BuyerWrapper> buyers = marketRequest.getBuyers();
            Set<Position> positions = marketRequest.getPositions();
            Set<String> positionIds = Sets.newHashSet();
            for (Position position : positions) {
                positionIds.add(position.getPositionId());
                positionIds.add(position.getAppPositionId());
            }
            List<Impression> imps = Lists.newArrayList(request.getImps());

            imps.removeIf(impression -> !positionIds.contains(impression.getTag_id()));
            final BidRequest e = new BidRequest();
            BeanUtils.copyProperties(request, e);
            e.setImps(imps);

            ExchangeResult result = exchanger.bidding(e, buyers);
            if (Objects.nonNull(result)) {
                exchangeResult.getDeals().addAll(result.getDeals());
                exchangeResult.addTrash(result.getTrash());
                exchangeResult.getBuyers().addAll(result.getBuyers());
            }
            // 如果当前有竞价结果，那么直接返回
            if (!AdxContextFactory.get().isOptimization()) {
                if (exchangeResult.exchangeSuccess()) {
                    return exchangeResult;
                }
            }
        }

        return exchangeResult;
    }
}
